package Benno::Container;

use strict;
use XML::LibXML;


sub new
{
    my $class = shift;
    my ($xml)  = @_;    # XML::LibXML object
    my $self  = {
        id    => '',
        index => '',
        repo  => '',
    };
    bless $self, $class;
    $self->_init($xml);

    return $self;
}


sub _init
{
    my ($self,$xml) = @_;

    $self->{id}    = $xml->findvalue('identifier');
    $self->{index} = $xml->findvalue('luceneindex/directory');
    $self->{repo}  = $xml->findvalue('boxgenerator/directory');

}


sub id
{
    $_[0]->{id} = $_[1] if $_[1];
    return $_[0]->{id};
}


sub index
{
    $_[0]->{index} = $_[1] if $_[1];
    return $_[0]->{index};
}


sub repo
{
    $_[0]->{repo} = $_[1] if $_[1];
    return $_[0]->{repo};
}


### EOP ###
1;
