package Benno::Box;
use parent 'Benno::Config';

=head1 SYNOPSIS

    use Benno::Box;

    my $Box = new Benno::Box($id);

    my $boxid = $Box->id;

    $Box->set_config($param);
    my $value = $Box->get_config($param);

=cut

=head1 METHODS

=head2 new($id)

    my $Box = new Benno::Box($id);

=head3 config parameter

  *  state
  *  authKey
  *  authKeyId
  *  bennoPath
  *  boxName
  *  bucket
  *  compression
  *  dirlength
  *  endpoint
  *  subdirs

=cut
sub new
{
    my $class = shift;
    my ($id)  = @_;
    my $self = {
        id => $id,
        config => {
            state       => '',
            authKey     => '',
            authKeyId   => '',
            bennoPath   => '',
            boxName     => '',
            bucket      => '',
            compression => '',
            dirlength   => '',
            endpoint    => '',
            subdirs     => '',
        },
    };
    bless $self, $class;

    return $self;
}


sub id
{
    my ($self) = @_;

    return $self->{id};
}


sub get_config
{
    my ($self,$attr) = @_;

    return $self->{config}->{$attr};
}


sub set_config
{
    my ($self,$attr,$value) = @_;

    $self->{config}->{$attr} = $value;
}


### EOP ###
1;
