package Benno::Container;
use parent 'Benno::Config';

use strict;
use XML::LibXML;


sub new
{
    my $class = shift;
    my ($xml)  = @_;    # XML::LibXML object
    my $self  = {
        id        => '',
        config    => {
            indexpath   => '',
            repopath    => '',
            authKey     => '',
            authKeyId   => '',
            bucket      => '',
            compression => '',
            dirlength   => '',
            endpoint    => '',
            subdirs     => '',
            storagetype => 'filesystem',
        },
    };

    bless $self, $class;
    $self->_init($xml);

    return $self;
}


sub _init
{
    my ($self,$xml) = @_;
    $self->id($xml->findvalue('identifier'));
    $self->set_config('indexpath',$xml->findvalue('luceneindex/directory'));

    if ($xml->findvalue('boxgenerator')) {  # boxgenerator config
        $self->set_config('repopath',$xml->findvalue('boxgenerator/directory'));
        $self->set_config('bucket',$xml->findvalue('boxgenerator/boxtemplate/storage/identifier'));
        $self->set_config('compression',$xml->findvalue('boxgenerator/boxtemplate/compression'));
        # S3
        if (my $endpoint = $xml->findvalue('boxgenerator/boxtemplate/storage/endpoint')) {
            $endpoint =~ s!^https://!!;
            $endpoint =~ s!/.*$!!;
            $self->set_config('endpoint',$endpoint);
            $self->set_config('storagetype','s3');
        }
        else {
            $self->set_config('subdirs',$xml->findvalue('boxgenerator/boxtemplate/storage/subdirs'));
            $self->set_config('dirlength',$xml->findvalue('boxgenerator/boxtemplate/storage/dirlength'));
        }
        # Encryption
        $self->set_config('authKeyId',$xml->findvalue('boxgenerator/boxtemplate/storage/authentication/authKeyId'));
        $self->set_config('authKey',$xml->findvalue('boxgenerator/boxtemplate/storage/authentication/authKey'));
    }
    else {  # legacy config
        $self->set_config('repopath',$xml->findvalue('fshexbennobox/directory'));
        $self->set_config('subdirs',$xml->findvalue('fshexbennobox/subdirs'));
        $self->set_config('dirlength',$xml->findvalue('fshexbennobox/dirlength'));
        $self->set_config('compression',$xml->findvalue('shexbennobox/compression'));
    }

}


sub id
{
    $_[0]->{id} = $_[1] if $_[1];
    return $_[0]->{id};
}


sub indexpath
{
    $_[0]->{config}->{indexpath} = $_[1] if $_[1];
    return $_[0]->{config}->{indexpath};
}


sub repopath
{
    $_[0]->{config}->{repopath} = $_[1] if $_[1];
    return $_[0]->{config}->{repopath};
}


### EOP ###
1;
