package Benno::EMLfile;
use strict;

=head1 NAME

Benno::EMLfile - Class representing EML file


=head1 SYNOPSIS

    use Benno::EMLfile;

    my $MailFile = new Benno::EMLfile($filename);

    print $Mailfile->eml;

    $Mailfile->save('/srv/benno/inbox');

=cut

=head1 METHODS

=head2 new($content)

    my $MailFile = new Benno::EMLfile($filename);

    Filename string without suffix.
=cut
sub new
{
    my $class = shift;
    my ($directory,$filename)  = @_;
    
    $filename || die "Filename not given\n";

    my $self = {
        direcotory  => $directory,
        filename    => $filename,
        mailcontent => '',
    };
    bless $self, $class;

    return $self;
}


=head2 eml()

    Return emlfile string;

=cut
sub eml
{
    my ($self) = @_;

    return $self->{mailcontent};
}


=head2 filename()

    Return the filename of the repo file.

=cut
sub filename
{
    my ($self) = @_;

    return $self->{filename};
}


=head2 save($content)

    Save content atomic in directory.

    Returns the filename of the export file.

=cut
sub save
{
    my ($self,$mailcontent) = @_;

    $self->{eml} = $mailcontent;

    my $filename = $self->{filename};

    my $tmpfile = $exportdir.'/'.$filename.'.tmp';
    my $emlfile = $exportdir.'/'.$filename.'.eml';

    -f $tmpfile and die "ERROR export $filename: $tmpfile exists\n";
    -f $emlfile and die "ERROR export $filename: $emlfile exists\n";
    open my $tmpfh, ">$tmpfile" or die "ERROR Cannot open tmpfile $tmpfile: $!\n";

    print $tmpfh $self->eml;

    close $tmpfh or die print STDERR "Cannot close $tmpfile. $!\n";

    if (link($tmpfile, $emlfile)) {
        unlink $tmpfile;
    }
    else {
        unlink $tmpfile;
        die "ERROR Cannot link $tmpfile to $emlfile. $!\n";
    }

    return $emlfile;
}


=head2 read_var($content)

    Reads the content from variable.

=cut
sub read_var 
{
    my ($self,$mailcontent) = @_;

    $self->{mailcontent} = $mailcontent;
}


=head2 read_file($filename)

    Reads content from file.

=cut
sub read 
{
    my ($self,$filename) = @_;

    open(my $fh, "<", $filename) || die "Cannot open $filename: $!\n";
    local $/;
    $self->{mailcontent} = <$fh>;
    close $fh;

}


### EOP ###
1;

