package Benno::Auth;
#
#
#
use strict;
use IPC::Open3;

sub new {
    my $class = shift;
    my ($module) = @_;

    my $self = {
        module      => $module,
        retlines    => [],
        errlines    => [],
        AUTH_OK     => 0,
    };
    bless $self, $class;

    return $self;
}


sub check
{
    my ($self,$user,$pass) = @_;

    my $archives = [];
    my($wtr, $rdr, $err);
    use Symbol 'gensym'; $err = gensym;
    my $pid = open3($wtr, $rdr, $err, $self->{module});
    print $wtr "$user\n$pass";

    close $wtr;
    waitpid( $pid, 0 );
    my $child_exit_status = $? >> 8;
    my @err = <$err>;
    my $failed = undef;
    foreach my $line (@err) {
        $failed = 1;
        chomp $line; chomp $line;
        push @{$self->{errlines}}, "$self->{module}: $line";
    }
    my @ret = <$rdr>;
    foreach my $line (@ret) {

        chomp $line; chomp $line;
        if ($line =~ /^ARCHIVE\s+?(.+)$/) {
            push @{$archives},$1;
        }
        if ($line =~ /^ERR/) {
            die $line;
        }
        if ($line =~ /^AUTH\sBREAK/) {
            die 'AUTH BREAK';
        }
        if ($line =~ /^AUTH\s+OK/) {
            $self->{AUTH_OK} = 1;
            next;
        }
        push @{$self->{retlines}}, $line;
    }
    die 'ERR INTERNAL' if $failed;
    die 'ERR AUTH' if ! $self->{AUTH_OK};
    return $archives;
}


sub get_archive { return $_[0]->{archive}; }


# EOP
1;

