#!/bin/sh
# postinst script for benno-web
#
# see: dh_installdeb(1)

set -e

# summary of how this script can be called:
#        * <postinst> `configure' <most-recently-configured-version>
#        * <old-postinst> `abort-upgrade' <new version>
#        * <conflictor's-postinst> `abort-remove' `in-favour' <package>
#          <new-version>
#        * <postinst> `abort-remove'
#        * <deconfigured's-postinst> `abort-deconfigure' `in-favour'
#          <failed-install-package> <version> `removing'
#          <conflicting-package> <version>
# for details, see http://www.debian.org/doc/debian-policy/ or
# the debian-policy package

USER_DB=bennoweb.sqlite
ETC_DIR=/etc/benno-web
VAR_DIR=/var/lib/benno-web
SERVER_CONFIG=/etc/benno-web/benno.conf
SERVER_USER=benno
SERVER_GROUP=benno
WWW_USER=www-data
WWW_GROUP=www-data


case "$1" in
    configure)
        chgrp $WWW_GROUP $SERVER_CONFIG
        chmod u=rw,g=r,o= $SERVER_CONFIG

        if [ ! -f "$VAR_DIR/$USER_DB" ];then
            zcat "/usr/share/doc/benno-web/${USER_DB}.gz" > "$VAR_DIR/$USER_DB"
            #ln -s "$VAR_DIR/$USER_DB" "$ETC_DIR"
        fi
        chown $WWW_USER "$VAR_DIR/$USER_DB"
        chmod u=rw,g=r,o= "$VAR_DIR/$USER_DB"
    ;;

    abort-upgrade|abort-remove|abort-deconfigure)
    ;;

    *)
        echo "postinst called with unknown argument \`$1'" >&2
        exit 1
    ;;
esac

/etc/init.d/apache2 force-reload


exit 0
