<?php
/*
 * Benno MailArchiv
 *
 * Copyright  2008-2012 LWsystems GmbH & Co. KG
 *
 * http://www.lw-systems.de/
 * http://www.benno-mailarchiv.de/
 *
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License version 3
 * as published by the Free Software Foundation.
 *
 * Binary versions of this file provided by LWsystems to you as
 * well as other copyrighted, protected or trademarked materials like
 * logos, graphics, fonts, specific documentations and configurations,
 * cryptographic keys etc. are subject to a license agreement between
 * you and LWsystems.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You can find a copy of the GNU Affero General Public License at
 * this URI:
 * http://www.gnu.org/licenses/agpl-3.0.html
 * If not, write to the Free Software Foundation, Inc., 59 Temple Place,
 * Suite 330, Boston, MA  02111-1307  USA
 */

/** $Id: $
 *
 * Copyright (c) 2007 Martin Werthmoeller <mw@lw-systems.de>
n *
 */
/**
 * @package Auth
 */
/**
 * 
 * Auth_LDAP
 *
 */
require_once 'DB/ldap.php';

class Auth
{

    /**
     * Class method to check authentication
     *
     * The necessary parameters LDAP_BASE and LDAP_HOST will be
     * directly fetchted from the config entries via the global $App
     * object.
     *
     * This will be performed to hold the authentication API constant
     * over all methods. The authentication will be done with 
     *
     *   Auth::check($userid,$password);
     *
     * Returns a TRUE value if authenticated.
     *
     * @access public
     * @param string $userid
     * @param string $bindpw
     * @return bool $succes
     */
    function check ($userid,$bindpw)
    {
        global $App;

        $LDAP_BASE = $App->getConfig('LDAP_BASE');
        if (! $LDAP_BASE) {
            error_log('**FATAL ERROR: LDAP_BASE is not configured in application configuration!**');
            return;
        }

        $LDAP_HOST = $App->getConfig('LDAP_HOST');

        if (! $LDAP_HOST) {
            $LDAP_HOST = 'localhost';
        }

        $binddn  = 'uid='.$userid.','.$LDAP_BASE;

        $param['username'] = $binddn;
        $param['password'] = $bindpw;
        $param['database'] = $binddn;
        $param['hostspec'] = $LDAP_HOST;

        $LDAP = new DB_ldap;
        $DB_OK = $LDAP->connect($param);
        if (DB::isError($DB_OK)) {
            error_log('Cannot connect to LDAP server: '.$DB_OK->getMessage());
            $success = FALSE;
        }
        else {
            $success = TRUE;
        }

        $LDAP->disconnect();

        return $success;
    }

}
?>
