<?php
/*
 * Benno MailArchiv
 *
 * Copyright  2008-2012 LWsystems GmbH & Co. KG
 *
 * http://www.lw-systems.de/
 * http://www.benno-mailarchiv.de/
 *
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License version 3
 * as published by the Free Software Foundation.
 *
 * Binary versions of this file provided by LWsystems to you as
 * well as other copyrighted, protected or trademarked materials like
 * logos, graphics, fonts, specific documentations and configurations,
 * cryptographic keys etc. are subject to a license agreement between
 * you and LWsystems.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You can find a copy of the GNU Affero General Public License at
 * this URI:
 * http://www.gnu.org/licenses/agpl-3.0.html
 * If not, write to the Free Software Foundation, Inc., 59 Temple Place,
 * Suite 330, Boston, MA  02111-1307  USA
 */

/** $Id: BaseMethods.php 2 2007-02-14 17:36:11Z martin $
 *
 * Copyright (c) 2006 Martin Werthmoeller <mw@werthmoeller.de>
 *
 */
/**
 * @package BaseMethods
 */
/**
 * 
 * Abstract class with base methods like getter and setter for SPAF
 * objects. The persistence class will inherit from this.
 *
 */

class BaseMethods
{
    /**
     * get(<attribute>);
     *
     * Returns the value of attribute.
     *
     * @access public
     * @param string $attribute
     * @return misc
     */
    function get ($attribute)
    {
        return $this->$attribute;
    }


    /**
     * set(<attribute>);
     *
     * Sets the value of attribute. Returns the attribute value.
     *
     * @access public
     * @param string $attribute 
     * @param misc $value
     * @return misc
     */
    function set ($attribute,$value)
    {
        $this->$attribute = $value;
        return $this->$attribute;
    }

    /**
     * setArray
     *
     * Sets the value of all attributes given at the array.
     *
     * @access public
     * @param array $array
     * @return object $this
     */
    function setArray ($array)
    {
        foreach ($array as $var => $value) {
            $this->$var = $value;
        }
        return $this;
    }



}
?>
