<?php
/*
 * Benno MailArchiv
 *
 * Copyright  2008-2012 LWsystems GmbH & Co. KG
 *
 * http://www.lw-systems.de/
 * http://www.benno-mailarchiv.de/
 *
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License version 3
 * as published by the Free Software Foundation.
 *
 * Binary versions of this file provided by LWsystems to you as
 * well as other copyrighted, protected or trademarked materials like
 * logos, graphics, fonts, specific documentations and configurations,
 * cryptographic keys etc. are subject to a license agreement between
 * you and LWsystems.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You can find a copy of the GNU Affero General Public License at
 * this URI:
 * http://www.gnu.org/licenses/agpl-3.0.html
 * If not, write to the Free Software Foundation, Inc., 59 Temple Place,
 * Suite 330, Boston, MA  02111-1307  USA
 */

/** $Id: LDAPAccess.php 2 2007-02-14 17:36:11Z martin $
 *
 * Copyright (c) 2006 Martin Werthmoeller <mw@lw-systems.de>
 *
 */
/**
 * @package LDAPAccess
 */
/**
 * 
 * Net_LDAP abstraction.
 *
 */
require 'Net/LDAP.php';


class LDAPAccess
{
    /**
     * @access public
     * @var binddn
     */
    var $binddn;


    /**
     * @access public
     * @var basedn
     */
    var $basedn;


    /**
     * @access public
     * @var bindpw
     */
    var $bindpw;


    /**
     * @access public
     * @var host
     */
    var $host;


    /**
     * @access public
     * @var LDAP
     */
    var $LDAP;


    /**
     * constructor
     *
     *
     * @access public
     * @param string $binddn
     * @param string $basedn
     * @param string $bindpw=''
     * @param string host='localhost'
     * @return object
     */
    function LDAPAccess ($binddn,$basedn,$bindpw='',$host='localhost')
    {
        $this->binddn = $binddn;
        $this->basedn = $basedn;
        $this->bindpw = $bindpw;
        $this->host   = $host;

        $param['base']     = $basedn;
        $param['dn']       = $binddn;
        $param['password'] = $bindpw;
        $param['tls']      = FALSE;
        $param['host']     = $host;

        $this->LDAP = &Net_LDAP::connect($param);
        if (Net_Ldap::isError($this->LDAP)) { 
            error_log('Cannot connect LDAP server: '.$this->LDAP->getMessage());
            die();
        }
    }



}
?>
