<?php
/*
 * Benno MailArchiv
 *
 * Copyright  2008-2012 LWsystems GmbH & Co. KG
 *
 * http://www.lw-systems.de/
 * http://www.benno-mailarchiv.de/
 *
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License version 3
 * as published by the Free Software Foundation.
 *
 * Binary versions of this file provided by LWsystems to you as
 * well as other copyrighted, protected or trademarked materials like
 * logos, graphics, fonts, specific documentations and configurations,
 * cryptographic keys etc. are subject to a license agreement between
 * you and LWsystems.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You can find a copy of the GNU Affero General Public License at
 * this URI:
 * http://www.gnu.org/licenses/agpl-3.0.html
 * If not, write to the Free Software Foundation, Inc., 59 Temple Place,
 * Suite 330, Boston, MA  02111-1307  USA
 */


class EMail
{

    var $id;
    var $bennoId;
    var $from;

    // array
    var $to;
    var $cc;
    var $bcc;

    var $subject;
    var $date;
    var $size;
    var $body;

    var $hasAttachment;
    var $attachments;


    function EMail ($id,$bennoId='',$from='',$to=array(),$cc=array(),$bcc=array(),$subject='',$date='',$size='',$body='',$hasAttachment=false)
    {
        $this->id       = $id; 
        $this->bennoId  = $bennoId; 
        $this->from     = $from;
        $this->to       = $to;
        $this->cc       = $cc;
        $this->bcc      = $bcc;
        $this->subject  = $subject;
        if ( !is_numeric($date) )
            $this->date = $date;
        else
            $this->date = $date." UTC";
        $this->size     = $size;
        $this->body     = $body;
        $this->hasAttachment = $hasAttachment;

        $this->attachments = array();
    }

    /**
     * Returns date as epoch integer
     *
     * @access public
     * @return int $epoch
     */
    function getDate ()
    {
        return strtotime($this->date);
    }


    /**
     * Returns string with header field
     *
     * @access public
     * @return string $body
     */
    function getFrom ()
    {
        return $this->from;
    }


    /**
     * Returns string with header field
     *
     * @access public
     * @return string $body
     */
    function getSubject()
    {
        return $this->subject;
    }


    /**
     * Returns string with header field
     *
     * @access public
     * @return string $body
     */
    function getTo ()
    {
        $return = '';
        foreach ($this->to as $value) {
            $return .= $value.' ';
        }
        return $return;
    }


    /**
     * Returns string with header field
     *
     * @access public
     * @return string $body
     */
    function getCc ()
    {
        $return = '';
        foreach ($this->cc as $value) {
            $return .= $value.' ';
        }
        return $return;
    }


    /**
     * Returns string with header field
     *
     * @access public
     * @return string $body
     */
    function getBcc ()
    {
        $return = '';
        foreach ($this->bcc as $value) {
            $return .= $value.' ';
        }
        return $return;
    }


    /**
     * Returns mail body in plain text
     *
     * @access public
     * @param string $contentType
     * @return string $body
     */
    function getBody($contentType='text/plain')
    {
        global $App;

        $body['text/plain'] = '';
        $body['text/html'] = '';
        $body['unknown'] = '';
        if (isset($this->body)) {
            foreach ($this->body as $bodypart) {
                $partContentType = $bodypart['content-type'];
                if (stripos($partContentType,'text/html') !== false) {
                    $body['text/html'] .= $bodypart['data'];
                    continue;
                }
                if (stripos($partContentType,'text/plain') !== false) {
                    $body['text/plain'] .= $bodypart['data'];
                    continue;
                }
                $body['unknown'] = $bodypart['data'];
            }

            $content = $body[$contentType];
            if (!$content) {
                if ($body['text/plain']) {
                    $App->log('[model/EMail] Only text/plain body found.');
                    throw new Exception('CONTENT_PLAIN');
                }
                if ($body['text/html']) {
                    $App->log('[model/EMail] Only text/html body found.');
                    throw new Exception('CONTENT_HTML');
                }
                $App->log('[model/EMail] Unknown body content in '.$this->bennoId);
                throw new Exception('CONTENT_UNKNOWN');
            }
        }                               // text/plain
        return $content;
    }


    /**
     * Add attachment object to attachment list
     */
    function addAttachment($attachment)
    {
        $this->hasAttachment = true;
        array_push($this->attachments,$attachment);
    }

}
?>
