#!/bin/sh
# preinst script for benno-archive
#

set -e

# summary of how this script can be called:
#        * <new-preinst> `install'
#        * <new-preinst> `install' <old-version>
#        * <new-preinst> `upgrade' <old-version>
#        * <old-preinst> `abort-upgrade' <new-version>
# for details, see http://www.debian.org/doc/debian-policy/ or
# the debian-policy package


case "$1" in
    install|upgrade)
        [ -z "$SERVER_USER" ] && SERVER_USER=www-data
        [ -z "$SERVER_GROUP" ] && SERVER_GROUP=www-data
        [ -z "$BENNO_SRV" ] && BENNO_SRV=/srv/benno
        [ -z "$SERVER_HOME" ] && SERVER_HOME=/srv/benno/bennoweb
        [ -z "$SERVER_HTDOCS" ] && SERVER_HTDOCS="$SERVER_HOME/htdocs"
        [ -z "$SERVER_TPL" ] && SERVER_TPL="$SERVER_HOME/templates"
        [ -z "$SERVER_CONF" ] && SERVER_CONF=/etc/benno-web
        [ -z "$SERVER_VAR" ] && SERVER_VAR=/var/lib/benno-web
        [ -z "$SERVER_CACHE" ] && SERVER_CACHE=/var/cache/benno-web/templates_c

        test -d $BENNO_SRV || mkdir $BENNO_SRV
        test -d $SERVER_HOME || mkdir $SERVER_HOME
        test -d $SERVER_HTDOCS || mkdir $SERVER_HTDOCS
        test -d $SERVER_TPL || mkdir $SERVER_TPL
        test -d $SERVER_CONF || mkdir $SERVER_CONF
        test -d $SERVER_VAR || mkdir $SERVER_VAR

        if [ -d $SERVER_CACHE ];then
            touch $SERVER_CACHE/%%DUMMY
            /bin/rm $SERVER_CACHE/%%*
        else
            mkdir -p $SERVER_CACHE
        fi

        # 5. adjust file and directory permissions
        if ! dpkg-statoverride --list $SERVER_VAR >/dev/null
        then
            chown $SERVER_USER $SERVER_VAR
            chmod u=rwx,g=rx,o= $SERVER_VAR
        fi

        if ! dpkg-statoverride --list $SERVER_CONF >/dev/null
        then
            chgrp $SERVER_GROUP $SERVER_CONF
            chmod u=rwx,g=rx,o= $SERVER_CONF
        fi

        if ! dpkg-statoverride --list $SERVER_CACHE >/dev/null
        then
            chown $SERVER_USER $SERVER_CACHE
            chmod u=rwx,g=rx,o=rx $SERVER_CACHE
        fi
    ;;
    abort-upgrade)
    ;;

    *)
        echo "preinst called with unknown argument \`$1'" >&2
        exit 1
    ;;
esac

# dh_installdeb will replace this with shell code automatically
# generated by other debhelper scripts.



exit 0
