<?php
/*
 * Benno MailArchiv
 *
 * Copyright  2008-2012 LWsystems GmbH & Co. KG
 *
 * http://www.lw-systems.de/
 * http://www.benno-mailarchiv.de/
 *
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License version 3
 * as published by the Free Software Foundation.
 *
 * Binary versions of this file provided by LWsystems to you as
 * well as other copyrighted, protected or trademarked materials like
 * logos, graphics, fonts, specific documentations and configurations,
 * cryptographic keys etc. are subject to a license agreement between
 * you and LWsystems.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You can find a copy of the GNU Affero General Public License at
 * this URI:
 * http://www.gnu.org/licenses/agpl-3.0.html
 * If not, write to the Free Software Foundation, Inc., 59 Temple Place,
 * Suite 330, Boston, MA  02111-1307  USA
 */


class MailAbstract
{

    var $id;
    var $from;
    var $to;
    var $multipart;
    var $subject;
    var $summary;
    var $date;


    function MailAbstract ($id,$from='',$to='',$multipart='',$subject='',$summary='',$date='')
    {
    
        $headers = "From: $from\nTo: $to\nSubject: $subject\n";
        $d_headers = iconv_mime_decode_headers($headers);
    
        $this->id        = htmlentities($id); 
    
        $this->from      = htmlentities($d_headers['From']);
    
    //    $this->to        = htmlentities($to);
        $this->to        = htmlentities($d_headers['To']);
        $this->multipart = htmlentities($multipart);
        $this->subject   = htmlentities($d_headers['Subject']);
        $this->summary   = htmlentities($summary); 
        $this->date      = substr(htmlentities($date), 6, 2).".".substr(htmlentities($date), 4, 2).".".substr(htmlentities($date), 0, 4); 
        $this->time      = substr(htmlentities($date), 8, 2).":".substr(htmlentities($date), 10); 
    }

}
?>
