<?php
/*
 * Benno MailArchiv
 *
 * Copyright  2008-2012 LWsystems GmbH & Co. KG
 *
 * http://www.lw-systems.de/
 * http://www.benno-mailarchiv.de/
 *
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License version 3
 * as published by the Free Software Foundation.
 *
 * Binary versions of this file provided by LWsystems to you as
 * well as other copyrighted, protected or trademarked materials like
 * logos, graphics, fonts, specific documentations and configurations,
 * cryptographic keys etc. are subject to a license agreement between
 * you and LWsystems.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You can find a copy of the GNU Affero General Public License at
 * this URI:
 * http://www.gnu.org/licenses/agpl-3.0.html
 * If not, write to the Free Software Foundation, Inc., 59 Temple Place,
 * Suite 330, Boston, MA  02111-1307  USA
 */

include_once 'model/Backend.php';

$QueryResult = $App->getSession('QueryResult');
$Backend     = $App->getSession('Backend');

$sessionMailId = $App->getParam('id');

try {
    $EMail = $Backend->fetch($sessionMailId);
    $displayedMailId = $sessionMailId;
    $App->setSession('displayedMailId',$displayedMailId);
}
catch (Exception $e) {
    $App->log('[j_loadEMail] '.$e->getMessage());
    $App->setMsg($e->getMessage());
}

$ret_email['From'] = $EMail->getFrom();
$ret_email['To'] = $EMail->getTo();
$ret_email['Subject'] = $EMail->getSubject();
$ret_email['Body'] = $EMail->getSubject();
$ret_email['Date'] = $EMail->getDateString('%d.%m.%Y');
$ret_email['Time'] = $EMail->getDateString('%H:%M');


try {
        $ret_email['Body'] = $EMail->getBody('text/plain');
}
catch (Exception $e) {
    $ExceptionMessage = $e->getMessage();
    if ($ExceptionMessage == 'CONTENT_HTML') {
        $App->assign('EMailBodyTemplate','showContentHtml.tpl');
    }
    else {
        $App->assign('EMailBodyTemplate','showContentUnknown.tpl');
    }
}

print json_encode($ret_email);

exit;
?>
