<?php
/*
 * Benno MailArchiv
 *
 * Copyright  2008-2012 LWsystems GmbH & Co. KG
 *
 * http://www.lw-systems.de/
 * http://www.benno-mailarchiv.de/
 *
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License version 3
 * as published by the Free Software Foundation.
 *
 * Binary versions of this file provided by LWsystems to you as
 * well as other copyrighted, protected or trademarked materials like
 * logos, graphics, fonts, specific documentations and configurations,
 * cryptographic keys etc. are subject to a license agreement between
 * you and LWsystems.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You can find a copy of the GNU Affero General Public License at
 * this URI:
 * http://www.gnu.org/licenses/agpl-3.0.html
 * If not, write to the Free Software Foundation, Inc., 59 Temple Place,
 * Suite 330, Boston, MA  02111-1307  USA
 */

/* $Id: ApplicationConfig.php 16 2007-06-07 16:49:40Z martin $ */
/**
 * @package Application
 * @subpackage Configuration
 *
 * Application Configuration
 *
 */

class ApplicationConfig
{
  
    /**
     * Configdir of this ApplicationConfig object.
     *
     * @access public
     * @var string
     */
    var $configdir;


    /**
     * Array with parameter => value pairs.
     *
     * @access public
     * @var array
     */
    var $parameters;

  /**
     * Constructor
     *
     * @access public
     * @param string $configdir
     * @return object
     */
    function ApplicationConfig ($configdir)
    {
        $this->configdir = $configdir;
    }


    /**
     * Parse configfile and overwrite the complete paramter set.
     *
     * Returns an array with the parameter => value pairs.
     *
     * @access public
     * @param string $file relative to configdir
     * @return array $parameters
     */
    function load ($file)
    {
        $this->parameters = '';
        $cfile = $this->configdir .'/'. $file;

        if (! $fd = @fopen ($cfile, "r")) {
            $dir = $_SERVER['SCRIPT_FILENAME'];
            $script_path = dirname($dir);
	        Application::Log('Cannot open config file: '.$script_path. '/'.$cfile);
            die ("Cannot open config file.\n");
        }
        while (!feof ($fd)) {
            $buffer = fgets($fd, 255);
            if (preg_match("/^#/",$buffer)) continue;
            if (preg_match("/^\s*$/",$buffer)) continue;
            list($param,$value) = preg_split ("/\s*=\s*/",$buffer,2);
            if (! $param)
                continue;
            $this->parameters[$param] = rtrim($value);
        }
        fclose($fd);

        return $this->parameters;
    }


    /**
     * Fetch message
     *
     * DEPREACHED! Compatibility method.
     * 
     * @access public
     * @return string $message
     * @param string $name
     */
    function getConfig ($name)
    {
        return $this->parameters[$name];
    }

    /**
     * Fetch message
     *
     * @access public
     * @return string $message
     * @param string $name
     */
    function get($name)
    {
        return $this->parameters[$name];
    }


  
}

?>
