<?php
/*
 * Benno MailArchiv
 *
 * Copyright  2008-2012 LWsystems GmbH & Co. KG
 *
 * http://www.lw-systems.de/
 * http://www.benno-mailarchiv.de/
 *
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License version 3
 * as published by the Free Software Foundation.
 *
 * Binary versions of this file provided by LWsystems to you as
 * well as other copyrighted, protected or trademarked materials like
 * logos, graphics, fonts, specific documentations and configurations,
 * cryptographic keys etc. are subject to a license agreement between
 * you and LWsystems.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You can find a copy of the GNU Affero General Public License at
 * this URI:
 * http://www.gnu.org/licenses/agpl-3.0.html
 * If not, write to the Free Software Foundation, Inc., 59 Temple Place,
 * Suite 330, Boston, MA  02111-1307  USA
 */

require_once 'model/DateConvert.php';


$timeslice = $App->getParam('search_min_select');
list($date_from,$date_to) = DateConvert::DateDiff($timeslice);

$searchstring = $App->getParam('searchmin');

$queryId = sha1($searchstring);
$SimpleQuery = new Query($queryId,$searchstring,$date_from,$date_to);
$SimpleQuery->setSortOrder($sortOrder);
$SimpleQuery->setSpam($App->getConfig('SHOW_SPAM'));

// reset extended query
$ExtQuery = new Query('empty');

try {
    // fresh search, thus we start with position 1
    $QueryResult = $Backend->query($SimpleQuery,0,$search_limit);
    if ($QueryResult->found == 0) {
        $App->setMsg('MSG_NOTFOUND');
    }
    $sessionMailId = $QueryResult->getSessionMailId(0);
    $EMail = $Backend->fetch($sessionMailId);       // show first mail
    $displayedMailId = $sessionMailId;
    $App->setSession('displayedMailId',$displayedMailId);
}
catch (Exception $e) {
    if ($e->getMessage() == 'ID_NOT_FOUND') {
        $EMail = '';
        $App->view = 'showList';
    }
    else {
        $App->log($e->getMessage());
        $App->setMsg($e->getMessage());
    }
}

$App->view = 'showList';

?>
