<?php
/*
 * Benno MailArchiv
 *
 * Copyright  2008-2012 LWsystems GmbH & Co. KG
 *
 * http://www.lw-systems.de/
 * http://www.benno-mailarchiv.de/
 *
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License version 3
 * as published by the Free Software Foundation.
 *
 * Binary versions of this file provided by LWsystems to you as
 * well as other copyrighted, protected or trademarked materials like
 * logos, graphics, fonts, specific documentations and configurations,
 * cryptographic keys etc. are subject to a license agreement between
 * you and LWsystems.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You can find a copy of the GNU Affero General Public License at
 * this URI:
 * http://www.gnu.org/licenses/agpl-3.0.html
 * If not, write to the Free Software Foundation, Inc., 59 Temple Place,
 * Suite 330, Boston, MA  02111-1307  USA
 */

// Class methods for date string conversion

class DateConvert
{

    function DateDiff ($before)
    {
        /**
         * Returns an array first and last timestamp for time differences
         *
         * Possible input values
         *
         * <numerical> - difference between now - $<num> and now 
         * thisYear    - first second of this year and now
         * lastYear    - first second of last year and last second of last year
         *
         * @return array
         */
        $now = time();
        $first = 0;
        $last  = 2147483647;
        if (is_numeric($before)) {
            $first = $now - $before * 86400;
            $last  = $now;
        } 
        elseif ($before == 'thisYear') {
            $year = strftime('%Y');
            $first = mktime(0, 0, 0, 1, 1, $year);
            $last  = $now;
        }
        elseif ($before == 'lastYear') {
            $lastyear = strftime('%Y')-1;
            $first = mktime(0, 0, 0, 1, 1, $lastyear);
            $last  = mktime(0, 0, 0, 1, 1, $year);
        }

        return array($first,$last);
    }

    /**
     * Converts a date (dd.mm.yyyy) to timestamp
     */
    function Date2Timestamp ($date,$date_format)
    {
        $timestamp = '';
        if ($date !== '') {
            if ($date_format == '%d.%m.%Y') {
                list($day,$month,$year) = preg_split('/\./',$date); 
            }
            else {
                list($month,$day,$year) = preg_split('/\//',$date); 
            }
            $timestamp = mktime(0,0,0,$month,$day,$year);
        }
        return $timestamp;
    }


    /**
     * Return current date (dd.mm.YYYY) of timestamp
     */
    function Timestamp2Date ($timestamp)
    {
        return strftime('%d.%m.%Y',$timestamp);
    }


}
?>
