<?php
/*
 * Benno MailArchiv
 *
 * Copyright  2008-2012 LWsystems GmbH & Co. KG
 *
 * http://www.lw-systems.de/
 * http://www.benno-mailarchiv.de/
 *
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License version 3
 * as published by the Free Software Foundation.
 *
 * Binary versions of this file provided by LWsystems to you as
 * well as other copyrighted, protected or trademarked materials like
 * logos, graphics, fonts, specific documentations and configurations,
 * cryptographic keys etc. are subject to a license agreement between
 * you and LWsystems.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You can find a copy of the GNU Affero General Public License at
 * this URI:
 * http://www.gnu.org/licenses/agpl-3.0.html
 * If not, write to the Free Software Foundation, Inc., 59 Temple Place,
 * Suite 330, Boston, MA  02111-1307  USA
 */

/** $Id: $
 *
 */
/**
 * @package AppUtils
 */

class AppUtils
{

// Browsersprache ermitteln
public static function GetLocaleFromBrowser($default_language,$strict_mode=true) {

    // $_SERVER['HTTP_ACCEPT_LANGUAGE'] verwenden
    $lang_variable = $_SERVER['HTTP_ACCEPT_LANGUAGE'];

    // wurde irgendwelche Information mitgeschickt?
    if (empty($lang_variable)) {
        // Nein? => Standardsprache zurückgeben
        return $default_language;
    }

    // Den Header auftrennen
    $accepted_languages = preg_split('/,\s*/', $lang_variable);

    // Die Standardwerte einstellen
    $current_lang = $default_language;
    $current_q = 0;

    // Nun alle mitgegebenen Sprachen abarbeiten
    foreach ($accepted_languages as $accepted_language) {
        // Alle Infos über diese Sprache rausholen
        $res = preg_match ('/^([a-z]{1,8}(?:-[a-z]{1,8})*)'.
                               '(?:;\s*q=(0(?:\.[0-9]{1,3})?|1(?:\.0{1,3})?))?$/i', $accepted_language, $matches);

        // war die Syntax gültig?
        if (!$res) {
            // Nein? Dann ignorieren
            continue;
        }
        
        // Sprachcode holen und dann sofort in die Einzelteile trennen
        $lang_code = explode ('-', $matches[1]);

        // Wurde eine Qualität mitgegeben?
        if (isset($matches[2])) {
            // die Qualität benutzen
            $lang_quality = (float)$matches[2];
        } else {
            // Kompabilitätsmodus: Qualität 1 annehmen
            $lang_quality = 1.0;
        }

        // Bis der Sprachcode leer ist...
        // Qualität anschauen
        if ($lang_quality > $current_q) {
            // diese Sprache verwenden
            // Wenn wir im strengen Modus sind, die Sprache nicht
            //minimalisieren 
            if ($strict_mode) {
                $current_lang = strtolower(join ('-', $lang_code));
            }
            else {
                $current_lang = strtolower($lang_code[0]);
            }
        }
        $current_q = $lang_quality;
    }
    // die gefundene Sprache zurückgeben
    return $current_lang;
}


}
?>
