<?php

function authentication_required($message)
{
    header('WWW-Authenticate: Basic realm="BENNOWEB REST API"');
    header('HTTP/1.0 401 Unauthorized');
    print $message."\n";
    exit;
}

if (!isset($_SERVER['PHP_AUTH_USER'])) {
    authentication_required('HTTP BASIC AUTHENTICATION REQUIRED');
}

require_once 'SPAF2/Application.php';
require_once 'model/User.php';
require_once 'model/Filter.php';

$configfile = "/etc/benno-web/benno.conf";
$UNICODE=TRUE;

ob_start();

$App = new Application($configfile,$_REQUEST,'');

$rest_user   = 'benno2';
$rest_pass   = $App->getConfig('SHARED_SECRET');
$base_url    = $App->getConfig('BASE_URL');
$authscript  = $App->getConfig('EXTERNAL_AUTH');

$userid   = $_SERVER['PHP_AUTH_USER'];
$passwd   = $_SERVER['PHP_AUTH_PW'];
$req_self = $_SERVER['PHP_SELF'];      // /search/ or /mail/

preg_match('/\/(\w+)\/?$/',$req_self,$matches);
$rest_path = $matches[1];

// Authentication
if (! $passwd) {
    $App->log('No password given.',1);
    authentication_required('NO PASSWORD GIVEN');
}

$User = new User($userid);
try {
    if ($authscript) {
        $User->loadExternal($authscript,$passwd);
    }
    else {
        $User->load();
        // check authentication
        if ($User->password != md5($passwd)) {
            throw new Exception('ERR_AUTH');
        }
    }
}
catch (Exception $e) {
    // Authentication error -> redirect to login
    $App->log($e->getMessage());
    authentication_required('AUTHENTICATION ERROR');
}
// Authentication successful

$cookie_file = $App->getConfig('COOKIE_FILE').$userid;

// mailadress filter
$FilterList = Filter::FetchList($User);
$filterString = '';
foreach ($FilterList as $Filter) {
    $filterString .= $Filter->getString();
}
$filterString = preg_replace('/\s/','%20',$filterString);

$query_request = $_SERVER['QUERY_STRING'];
$query_request = preg_replace('/[\&]?\bfilterQuery=[^\&]+/','',$query_request);
$archives = $User->getArchives();
$archive       = 'archive='.end($archives);
$filterQuery   = 'filterQuery='.$filterString;
$query_request = $filterQuery.'&'.$archive.'&'.$query_request;

// remove possible filter entries from query
$url = $base_url.'/'.$rest_path.'/?'.$query_request;

// Open the cURL session
$curl = curl_init();

curl_setopt($curl, CURLOPT_URL, $url);
curl_setopt($curl, CURLOPT_HEADER, 1);
curl_setopt($curl, CURLOPT_USERPWD, $rest_user.':'.$rest_pass);

if($_SERVER['REQUEST_METHOD'] == 'POST'){
	curl_setopt($curl, CURLOPT_POST, 1);
	curl_setopt($curl, CURLOPT_POSTFIELDS, $_POST);
}

curl_setopt($curl, CURLOPT_RETURNTRANSFER,1);
curl_setopt($curl, CURLOPT_TIMEOUT,30);
curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, 0);
curl_setopt($curl, CURLOPT_COOKIEJAR, $cookie_file);
curl_setopt($curl, CURLOPT_COOKIEFILE, $cookie_file);

//Send the request and store the result in an array
$response = curl_exec($curl);


// Check that a connection was made
if(curl_error($curl)){
        print curl_error($curl);
} else {
    list($response_headers, $response_body) = explode("\r\n\r\n", $response, 2);

    $header_array = preg_split('/\n/',$response_headers);
	foreach($header_array as $header_name => $header_value){
        //handle headers - simply re-outputing them
        header(trim($header_value));
	}

    print $response_body;
}
curl_close($curl);

?>
