#!/bin/sh
# postrm script for benno-web
#
# see: dh_installdeb(1)

set -e

# summary of how this script can be called:
#        * <postrm> `remove'
#        * <postrm> `purge'
#        * <old-postrm> `upgrade' <new-version>
#        * <new-postrm> `failed-upgrade' <old-version>
#        * <new-postrm> `abort-install'
#        * <new-postrm> `abort-install' <old-version>
#        * <new-postrm> `abort-upgrade' <old-version>
#        * <disappearer's-postrm> `disappear' <overwriter>
#          <overwriter-version>
# for details, see http://www.debian.org/doc/debian-policy/ or
# the debian-policy package


case "$1" in
    purge|remove|upgrade|failed-upgrade|abort-install|abort-upgrade|disappear)
        # Debian package "base-files" has created /opt and /srv in postinstall
        # script, thus this dirs will not appear as system directories.
        # They will be removed if no other package referenced to it in
        # .../info/*.list
        test -d /opt || mkdir /opt
        test -d /srv || mkdir /srv
        set +e
        test -x /usr/sbin/a2disconf && /usr/sbin/a2disconf benno 2>/dev//null
        set -e
    ;;

    *)
        echo "postrm called with unknown argument \`$1'" >&2
        exit 1
    ;;
esac

# dh_installdeb will replace this with shell code automatically
# generated by other debhelper scripts.



set +e
case "$1" in
    purge)
        if [ -f /etc/benno-web/rest.conf ];then
        /bin/rm /etc/benno-web/rest.conf
    fi
    ;;
esac
set -e


exit 0
