<?php
/*
 * Benno MailArchiv
 *
 * Copyright  2008-2017 LWsystems GmbH & Co. KG
 *
 * http://www.lw-systems.de/
 * http://www.benno-mailarchiv.de/
 *
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License version 3
 * as published by the Free Software Foundation.
 *
 * Binary versions of this file provided by LWsystems to you as
 * well as other copyrighted, protected or trademarked materials like
 * logos, graphics, fonts, specific documentations and configurations,
 * cryptographic keys etc. are subject to a license agreement between
 * you and LWsystems.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You can find a copy of the GNU Affero General Public License at
 * this URI:
 * http://www.gnu.org/licenses/agpl-3.0.html
 * If not, write to the Free Software Foundation, Inc., 59 Temple Place,
 * Suite 330, Boston, MA  02111-1307  USA
 */


//Das Laden der Session Konfiguration muss vorher geschehen, da init_session nicht nach hinten verschoben werden kann. Ohne
//diese Maßnahme lädt die Session Konfiguration nicht.
$CookieConfig = new ApplicationConfig(dirname($configfile));
$CookieConfig->load(basename($configfile));

if ($CookieConfig->getConfig('UNENCRYPTED_ACCESS')) {
    ini_set('session.cookie_secure',false);
    ini_set('session.cookie_httponly',false);
}
else {
    ini_set('session.cookie_secure',true);
    ini_set('session.cookie_httponly',true);
    ini_set('session.cookie_samesite','Lax');
}

// check cookie settings
if (ini_get('session.cookie_secure')) {
    @$_SERVER['HTTPS'] || error_log('BENNO RUNTIME ERROR: plaintext request while secure cookies enabled');
}

// set cookie path
$currentCookieParams = session_get_cookie_params();
session_set_cookie_params(
    $currentCookieParams["lifetime"],
    dirname($_SERVER['SCRIPT_NAME']),
    $_SERVER["HTTP_HOST"],
    $currentCookieParams["secure"],
    $currentCookieParams["httponly"]
);

session_name('BENNOSID');
session_start();

?>
