<?php
/*
 * Benno MailArchiv
 *
 * Copyright  2008-2012 LWsystems GmbH & Co. KG
 *
 * http://www.lw-systems.de/
 * http://www.benno-mailarchiv.de/
 *
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License version 3
 * as published by the Free Software Foundation.
 *
 * Binary versions of this file provided by LWsystems to you as
 * well as other copyrighted, protected or trademarked materials like
 * logos, graphics, fonts, specific documentations and configurations,
 * cryptographic keys etc. are subject to a license agreement between
 * you and LWsystems.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You can find a copy of the GNU Affero General Public License at
 * this URI:
 * http://www.gnu.org/licenses/agpl-3.0.html
 * If not, write to the Free Software Foundation, Inc., 59 Temple Place,
 * Suite 330, Boston, MA  02111-1307  USA
 */
// handle initial request for OAuth2 authentication / authorization
require_once 'pre_init.php';

$scheme         = $_SERVER['REQUEST_SCHEME'];
$httpHost       = $_SERVER['HTTP_HOST'];

$authHost       = $App->getConfig('OAUTH2_HOST');
$redirectPath   = $App->getConfig('OAUTH2_REDIRECTPATH');
$authScope      = $App->getConfig('OAUTH2_AUTHSCOPE','openid');
$contextPath    = $App->getConfig('OAUTH2_CONTEXTPATH','/benno/v3.0');


$redirect_uri = $scheme.'://'.$httpHost.$redirectPath;
$redirect_path = "$contextPath/oauth2/authorize?response_type=code&client_id=bennoweb&scope=$authScope&redirect_uri=$redirect_uri&vhost=$authHost";
header('Location: '.$authHost.$redirect_path);
exit;

?>
