#!/usr/bin/perl
#
#
use strict;
use IPC::Open3;

my $DEBUG = $ENV{DEBUG};
my $auth_success = 0;

my $config     = read_config('/etc/benno-web/auth.conf');
my $module_dir = $config->{module_dir} || '/etc/benno-web/auth.d';

$ENV{module_dir} = $module_dir;
foreach my $configvar (keys %{$config}) {
    $ENV{$configvar} = $config->{$configvar};
}


my $firstline  = <STDIN>;
my $secondline = <STDIN>;
chomp $firstline;
chomp $secondline;

my $authproto;
my ($username,$password);
if (!$secondline) {
    # AUTHPROTO: STDIN
    ($username,$password) = split /\s+/,$firstline,2;
    $authproto = 1;
}
else {
    # AUTHPROTO: STDIN2
    $username = $firstline;
    $password = $secondline;
    $authproto = 2;
}
if (!$password) {
    print "ERROR ERR_NOPASS\n";
    print STDERR "Aufruf: echo -e \"<username>\n<passwort>\" | $0\n";
    exit 1;
}
$ENV{AUTHLINES} = '';
$ENV{AUTHOK} = '';
my (@retlines,@errlines);
my (%mailaddresses);
my $m_count   = 0;
my $no_user   = 1;
my $auth_last = 0;
chdir $module_dir;
opendir my $dh, $module_dir or die "Cannot read $module_dir/: $!";
foreach my $file (sort readdir($dh)) {
    next if $file =~ /^\./;
    next if $file =~ /\.dpkg/;
    next if not -f $file;

    my $module = $module_dir.'/'.$file;
    next unless -x $module;
    $m_count++;
    print STDERR "Call $module\n" if $DEBUG;
    my $authstring;
    if ($authproto == 2) {
        $authstring = "$username\n$password";
    }
    else {
        $authstring = "$username $password";
    }

    my($wtr, $rdr, $err);
    use Symbol 'gensym'; $err = gensym;
    my $pid = open3($wtr, $rdr, $err, $module);
    print $wtr $authstring;
    close $wtr;
    waitpid( $pid, 0 );
    my $child_exit_status = $? >> 8;
    my @err = <$err>;
    foreach my $line (@err) {
        chomp $line; chomp $line;
        my ($basename) = $module =~ m!.*?([^/]+?)$!;
        push @errlines, "$basename: $line";
    }
    my @ret = <$rdr>;
    foreach my $line (@ret) {
        $line =~ s/\R$//;
        if ($line =~ /^ERR/) {
            if ($line =~ /^ERROR ERR_AUTH/) {
                $no_user = 0;
                next;               # no logging of auth error 
            }
            print STDERR "$module: $line\n";
            next; # no error to caller
        }
        if ($line =~ /^AUTH\sBREAK/) {
            print "WARN AUTH BREAK from $module\n";
            error_exit('ERR_AUTH');
        }
        if ($line =~ /^AUTH\sLAST$/) {
            $auth_last = 1;
        }
        if ($line =~ /^AUTH\s+OK/) {
            $no_user = 0;
            $auth_success = 1;
            $ENV{AUTHOK} = 1;
            next;
        }

        if ($line =~ /^MAIL\s+(.+)$/) {
            $mailaddresses{$1} = 1;
            next;
        }

        push @retlines, $line;
        $ENV{AUTHLINES} .= $line."\n";
    }
    last if $auth_last;
}

# add uniqified mail adresses
if (!$m_count) {
    print STDERR "No auth module enabled\n";
}

# add uniqified mail adresses
foreach my $uaddr (keys %mailaddresses) {
    push @retlines, "MAIL $uaddr";
}

# return errors
foreach my $errline (@errlines) {
    print STDERR "$errline\n";
}

# return retlines
foreach my $retline (@retlines) {
    print "$retline\n";
}

if ($auth_success) {
    print "AUTH OK\n";
    exit 0;
}
else {
    my $err_sym = ($no_user ? 'ERR_NOUSER' : 'ERR_AUTH');
    error_exit($err_sym);
}


### SUBS ###
# read_config
sub read_config
{
    my $configfile = shift;
    my $config = {};

    # Config format:   var = val
    open CONF, "$configfile" or die "Cannot open config file $configfile. $!\n";
    foreach my $line (<CONF>) {
        next if $line =~ /^$/;
        next if $line =~ /^#/;
        chomp $line;
        my ($var,$val) = split(/=/, $line,2);
        # strip ws
        $var =~ s/\s//g;
        $val =~ s/^\s+//g;
        $val =~ s/\s+$//g;
        $config->{$var} = $val;
    }
    close CONF;
    return $config;
}

sub error_exit
{
    my $errsym = shift;
    print "ERROR $errsym\n";
    exit 1;
}

#
# vim: set filetype=perl:
#
