<?php
/*
 * Benno MailArchiv
 *
 * Copyright  2008-2025 LWsystems GmbH & Co. KG
 *
 * http://www.lw-systems.de/
 * http://www.benno-mailarchiv.de/
 *
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License version 3
 * as published by the Free Software Foundation.
 *
 * Binary versions of this file provided by LWsystems to you as
 * well as other copyrighted, protected or trademarked materials like
 * logos, graphics, fonts, specific documentations and configurations,
 * cryptographic keys etc. are subject to a license agreement between
 * you and LWsystems.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You can find a copy of the GNU Affero General Public License at
 * this URI:
 * http://www.gnu.org/licenses/agpl-3.0.html
 * If not, write to the Free Software Foundation, Inc., 59 Temple Place,
 * Suite 330, Boston, MA  02111-1307  USA
 */

require_once 'SPAF2/Persistence.php';

class ContainerBackend extends Persistence
{

    var $id;
    var $url;
    var $auth_data;
    var $auth_type;
    var $request_order;


    public function __construct($id,$url='',$auth_type='Basic',$auth_data='Ogo=',$request_order=0)
    {
        $this->id               = $id;
        $this->url              = $url;
        $this->auth_type        = $auth_type;
        $this->auth_data        = $auth_data;
        $this->request_order    = $request_order;
    }


    public static function getBackends($container) {
        global $App;
        $DB = $App->DB;

        $container_backends = array();

        // check if table exist and return empty array on error
        //$sql = "SHOW TABLES LIKE 'containerbackend'";
        //$sth = $DB->db->prepare($sql);
        //if (! $sth->execute()) {
        //    $App->log('Error table containerbackend not initialized',4);
        //    return $container_backends;
        //}
        
        $sql = "SELECT * FROM containerbackend WHERE id=? ORDER BY request_order";
        $sth = $DB->db->prepare($sql);

        $sth->bindValue(1,$container);
        try {
            if($sth->execute()) {
                while ($row = $sth->fetch()) {
                    $obj = new ContainerBackend($row['id'],$row['url'],$row['auth_type'],$row['auth_data'],$row['request_order']);
                    array_push($container_backends,$obj);
                }
            }
        } catch (Exception $e) {
            $App->log('Error query table containerbackends: '.$e->getMessage(),4);
        }

        return $container_backends;
    }


    public function container       () { return $this->id;              }
    public function url             () { return $this->url;             }
    public function auth_data       () { return $this->auth_data;       }
    public function auth_type       () { return $this->auth_type;       }
    public function request_order   () { return $this->request_order;   }
 
}
?>
