<?php
/*
 * Benno MailArchiv
 *
 * Copyright  2008-2012 LWsystems GmbH & Co. KG
 *
 * http://www.lw-systems.de/
 * http://www.benno-mailarchiv.de/
 *
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License version 3
 * as published by the Free Software Foundation.
 *
 * Binary versions of this file provided by LWsystems to you as
 * well as other copyrighted, protected or trademarked materials like
 * logos, graphics, fonts, specific documentations and configurations,
 * cryptographic keys etc. are subject to a license agreement between
 * you and LWsystems.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You can find a copy of the GNU Affero General Public License at
 * this URI:
 * http://www.gnu.org/licenses/agpl-3.0.html
 * If not, write to the Free Software Foundation, Inc., 59 Temple Place,
 * Suite 330, Boston, MA  02111-1307  USA
 */

require_once 'model/User.php';
require_once 'model/DateConvert.php';
require_once 'model/Filter.php';
require_once 'model/AppState.php';


$base_url    = $App->getConfig('BASE_URL');
$authscript  = $App->getConfig('EXTERNAL_AUTH');

$login = $App->getParam('login');

$userid = $login['username'];
$pass = $login['password'];

if (! $pass) {
    $App->redirect('default',array('MSG'=>'ERR_NOPASS'));
}

$User = new User($userid);
try {
    if ($authscript) {
        $User->loadExternal($authscript,$pass);
    }
    else {
        $User->load();
        // check authentication
        if ($User->password != md5($pass)) {
            // Authentication error -> redirect to login
            $App->log('Authentication of '.$User->id.' failed');
            $App->redirect('default',array('MSG'=>'ERR_AUTH'));
        }
    }
}
catch (Exception $e) {
    $exc = $e->getMessage();
    $App->log('Authentication error: '.$exc);
    $App->redirect('default',array('MSG'=>$exc));
}

// LOGIN SUCCESSFUL
$App->log('Authentication of '.$User->id. ' successful',1);

// initialize backend
$archive_list = $User->getArchives();
$archive = end($archive_list);
$FilterList = Filter::FetchList($User);
$filterString = '';
foreach ($FilterList as $Filter) {
    $filterString .= $Filter->getString();
}
$Backend = new Backend($base_url,$filterString);

// initialize session
$App->setSession('ACCESS_LEVEL',$User->getAuthzLevel());
$App->setSession('USER',$User);
$App->setSession('Backend',$Backend);   // store backend for this session
$App->setSession('archive',$archive);   // store current archive
$App->setSession('FilterList',$FilterList);

// defaults for extended search form
$timerange = $App->getConfig('DEFAULT_TIMERANGE');
$ExtQuery = new Query('empty');
$App->setSession('ExtQuery',$ExtQuery);

$App->setSession('QueryList',StoredQuery::FetchList($User->id));

// restore state of last session
try {
    // searchMask
    $AppState = new AppState($User->id);
    $searchMaskState = $AppState->getValue('searchMaskState','Simple');
    $App->setSession('searchMaskState',$searchMaskState);

    // Language
    if ($App->getParam('interfaceLanguage')) {
        $AppState->setValue('userLanguage',$App->getParam('interfaceLanguage'));
        $App->setLang($App->getParam('interfaceLanguage'));
    }
    else {
        $userLanguage = $AppState->getValue('userLanguage');
        if ($userLanguage) {
            $App->setLang($userLanguage);
        }
    }
}
catch (Exception $e) {
    $App->log('Error loading application state: '.$e->getMessage());
}

// redirect after login
if (!$redirect = $App->getSession('LOGIN_REDIRECT')) {
    $redirect = 'greeting';
}
$App->redirect($redirect);

?>
