<?php
/*
 * Benno MailArchiv
 *
 * Copyright  2008-2012 LWsystems GmbH & Co. KG
 *
 * http://www.lw-systems.de/
 * http://www.benno-mailarchiv.de/
 *
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License version 3
 * as published by the Free Software Foundation.
 *
 * Binary versions of this file provided by LWsystems to you as
 * well as other copyrighted, protected or trademarked materials like
 * logos, graphics, fonts, specific documentations and configurations,
 * cryptographic keys etc. are subject to a license agreement between
 * you and LWsystems.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You can find a copy of the GNU Affero General Public License at
 * this URI:
 * http://www.gnu.org/licenses/agpl-3.0.html
 * If not, write to the Free Software Foundation, Inc., 59 Temple Place,
 * Suite 330, Boston, MA  02111-1307  USA
 */

$rest_user   = 'benno2';
$rest_pass   = $App->getConfig('SHARED_SECRET');
$base_url    = $App->getConfig('BASE_URL');
$cookie_file = $App->getConfig('COOKIE_FILE').$User->id;

// bild path for REST request
$req_self = $_SERVER['PHP_SELF'];      // /search/ or /mail/
preg_match('/\/(\w+)\/?$/',$req_self,$matches);
$rest_path = $matches[1];


// mailadress filter
$FilterList = Filter::FetchList($User);
$filterString = '';
foreach ($FilterList as $Filter) {
    $filterString .= $Filter->getString();
}
$filterString = preg_replace('/\s/','%20',$filterString);

$query_request = $_SERVER['QUERY_STRING'];
$query_request = preg_replace('/[\&]?\bfilterQuery=[^\&]+/','',$query_request);
$archives = $User->getArchives();
$archive       = 'archive='.end($archives);
$filterQuery   = 'filterQuery='.$filterString;
$query_request = $filterQuery.'&'.$archive.'&'.$query_request;

// remove possible filter entries from query
$url = $base_url.'/'.$rest_path.'/?'.$query_request;

// Open the cURL session
$curl = curl_init();

curl_setopt($curl, CURLOPT_URL, $url);
curl_setopt($curl, CURLOPT_HEADER, 1);
curl_setopt($curl, CURLOPT_USERPWD, $rest_user.':'.$rest_pass);

curl_setopt($curl, CURLOPT_RETURNTRANSFER,1);
curl_setopt($curl, CURLOPT_TIMEOUT,30);
curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, 0);
curl_setopt($curl, CURLOPT_COOKIEJAR, $cookie_file);
curl_setopt($curl, CURLOPT_COOKIEFILE, $cookie_file);

// suppress using of 100-Continue requests
curl_setopt($curl, CURLOPT_HTTPHEADER,array("Expect:"));

if($_SERVER['REQUEST_METHOD'] == 'POST'){
	curl_setopt($curl, CURLOPT_POST, 1);
    // !!! request must be send as  (could be changed in future) !!!
    //  Content-Type: application/x-www-form-urlencoded
    $post_data = http_build_query($_POST);
	curl_setopt($curl, CURLOPT_POSTFIELDS, $post_data);
}


// prepare reqeust debugging
$loglevel = $App->loglevelForModule('rest_backend');
if ($loglevel >= 2) {
    curl_setopt($curl, CURLOPT_VERBOSE, true);
    $tmpfile = fopen('php://temp', 'w+');
    curl_setopt($curl, CURLOPT_STDERR, $tmpfile);
}

//Send the request and store the result in an array
$response = curl_exec($curl);
$res_code = curl_getinfo($curl,CURLINFO_HTTP_CODE);

// fetch debug info
if ($loglevel >= 2) {
    rewind($tmpfile);
    $curl_verbose = stream_get_contents($tmpfile);
    fclose($tmpfile);
    $App->log($curl_verbose,2,'rest_backend');
}

// Check that a connection was made
if(curl_error($curl)){
    print curl_error($curl);
} else {
    list($response_headers, $response_body) = explode("\r\n\r\n", $response, 2);

    $header_array = preg_split('/\n/',$response_headers);
	foreach($header_array as $header_value){
        // Bei grossen Responses Fehler mit zu grossen Headern (REST Response?)
        //handle headers - simply re-outputing them
        if (!preg_match('/^Content-Type/', $header_value)) {
            continue;
        }
        header(trim($header_value));
	}
    http_response_code($res_code);
    print $response_body;
}
curl_close($curl);

?>
