<?php
/*
 * Benno MailArchiv
 *
 * Copyright  2008-2012 LWsystems GmbH & Co. KG
 *
 * http://www.lw-systems.de/
 * http://www.benno-mailarchiv.de/
 *
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License version 3
 * as published by the Free Software Foundation.
 *
 * Binary versions of this file provided by LWsystems to you as
 * well as other copyrighted, protected or trademarked materials like
 * logos, graphics, fonts, specific documentations and configurations,
 * cryptographic keys etc. are subject to a license agreement between
 * you and LWsystems.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You can find a copy of the GNU Affero General Public License at
 * this URI:
 * http://www.gnu.org/licenses/agpl-3.0.html
 * If not, write to the Free Software Foundation, Inc., 59 Temple Place,
 * Suite 330, Boston, MA  02111-1307  USA
 */

/**
 * $Id: SPAF2.php 26:4f3aa516a917 2012-02-19 15:00 +0100 mw $
 */
/**
 * @category SPAF2
 * @package Controller
 * @author Martin Werthmoeller <mw@werthmoeller.de>
 *
 * Central controller file of this application 
 *
 * Every request to this web appapplication will sent to the index.php
 * file. It is the central component of the controller part.
 *
 */


$SPAF_VERSION = '2.2.0';
header('Content-Type: text/html; charset=utf-8');

$MODULE = preg_replace('/\.php$/','', basename($_SERVER['SCRIPT_NAME']));
if (! file_exists($MODULE)) {
    $MODULE = '.';
}
else {
    ini_set('include_path',ini_get('include_path').':./'.$MODULE);
}

/**
 * Allow php to load classes at first.
 */
if (file_exists($MODULE.'/pre_init.php')) {
    require $MODULE.'/pre_init.php';
}

require 'SPAF2/Application.php';

if ((! isset($SP_CONFIG)) && (! isset($configfile))) {
    echo "Main configfile not set!";
    exit();
}

require_once 'init_session.php';

// suppress notice messages 
error_reporting(error_reporting()&~E_NOTICE);

/**
 * Application framework object
 *
 * @global object $App Application object
 */
$App = new Application($configfile,$_REQUEST,$MODULE);


function eor ()
{
    global $App;
    $App->log('>>> eor ----------------------------------',1,'SPAF2');
    exit();
}


// Langage settings
if ($App->getParam('LANG')) {
    $App->setLang($App->getParam('LANG'));
    $App->setSession('LANG',$App->getParam('LANG'));
}
elseif ($App->getSession('LANG')) {
    $App->setLang($App->getSession('LANG'));
}
else {
    if ($App->getConfig('FORCE_DEFAULT_LANGUAGE') == 'true') {
        $App->setLang($App->getConfig('DEFAULT_LANGUAGE','de'));
    }
    else {
        require_once 'model/AppUtils.php';
        $App->setLang(AppUtils::GetLocaleFromBrowser(
                        $App->getConfig('DEFAULT_LANGUAGE','de'),
                        false));
    }
}
$App->setSkin($App->getConfig('SKINDIR','default'));

// fetch user variable from session
$USER = $App->getSession('USER');
$App->assign('USER',$USER);

$DEBUG = $App->getConfig('DEBUG');

/**
 * Fetch message information from request and assign to the MSG
 * template variable. The $msg_sym is defined at the ERRORMSG file.
 */
$msg_sym = $App->getParam('MSG');
if ($msg_sym) {
    $App->setMsg($msg_sym);
}

if (array_key_exists('PATH_INFO',$_SERVER)) {
    $CURRENT_ACTION = trim($_SERVER['PATH_INFO'],'/');
}
else {
    $CURRENT_ACTION = $App->getParam('CA');
}

if (! $CURRENT_ACTION || ! preg_match('/^[a-zA-Z0-9_-]+$/',$CURRENT_ACTION)) {
    $CURRENT_ACTION = 'default';
}

$App->log("CA $CURRENT_ACTION",2,'SPAF2');
$App->view = $CURRENT_ACTION;

/* *** PRE CTRL HOOK ***/
if (file_exists($MODULE.'/pre_ctrl.php')) {
    $App->log("CALL $MODULE/pre_ctrl.php",3,'SPAF2');
    require $MODULE.'/pre_ctrl.php';
}
/**********************************************************************
 ** CTRL
 *
 * Check if file exists or call default controller file. The default
 * controller will not checked for authorization.
 *
 */
$SP_FILE = $MODULE.'/ctrl/' . $CURRENT_ACTION . '.php';
if (file_exists($SP_FILE)) {
    if ($App->authz($CURRENT_ACTION)) {
        $App->log("CALL $SP_FILE",3,'SPAF2');
        include $SP_FILE;
    }
    else {
        // authzError
        $App->log("ERR_AUTHZ $SP_FILE",1,'SPAF2');
        $App->view = 'error';
    }
}

/* *** POST CTRL HOOK ***/
if (file_exists($MODULE.'/post_ctrl.php')) {
    $App->log("CALL $MODULE/post_ctrl.php",3,'SPAF2');
    require $MODULE.'/post_ctrl.php';
}

/* *** VIEW ***
 *
 * Check if file exists or call default controller file. The default
 * controller will not checked for authorization.
 *
 */
$App->log("VIEW ".$App->view,2,'SPAF2');
// check if file exists or call default view file. The default view
// will not checked for authorization.
$SP_FILE = $MODULE.'/view/' . $App->view . '.php';
if (file_exists($SP_FILE)) {
    if ($App->authz($App->view)) {
        $App->log("CALL $SP_FILE",3,'SPAF2');
        include $SP_FILE;
    }
    else {
        // authzError
        $App->log("ERR_AUTHZ $SP_FILE",0,'SPAF2','SPAF2');
        $App->view = 'error';
    }
}

/* *** POST VIEW HOOK ***/
if (file_exists($MODULE.'/post_view.php')) {
    $App->log("CALL $MODULE/post_view.php",3,'SPAF2');
    require $MODULE.'/post_view.php';
}

/* Check template authorization */
if ($App->getConfig('TEMPLATE_AUTHZ',true) &! $App->authz($App->view)) {
    // authzError
    $App->log("ERR_AUTHZ Template: $App->view.tpl",0,'SPAF2');
    $App->view = 'error';
}


$App->tplConfig();

$App->assign('ACCESS_LEVEL',$App->accessLevel());
$App->assign('CA',$App->getparam('CA'));
$App->assign('DEBUG',$App->DEBUG);
$App->assign('LOCALE_TXT',$App->locale_txt);
$App->assign('SID',session_id());
$App->assign('SN',session_name());
$App->assign('VIEW',$App->view);

if ($App->getParam('SKIN')) {
    $App->setSkin($App->getParam('SKIN'));
}

$App->log("TPL $App->view",2,'SPAF2');
$App->template = $App->view;
// header and footer relative to template_root
$App->compile($App->TPL->getTemplateDir(0).'/header.tpl');
// Append '.tpl' extension
if (! preg_match('/\.[[:alnum:]]{1,3}$/',$App->template))
     $App->template .= '.tpl';
$App->compile($App->TPL->getTemplateDir(0).'/'.$App->template);
$App->compile($App->TPL->getTemplateDir(0).'/footer.tpl');

// return the response
$App->display();
$App->log("------------------------------------------",1,'SPAF2');
?>
