<?php
/*
 * Benno MailArchiv
 *
 * Copyright  2008-2012 LWsystems GmbH & Co. KG
 *
 * http://www.lw-systems.de/
 * http://www.benno-mailarchiv.de/
 *
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License version 3
 * as published by the Free Software Foundation.
 *
 * Binary versions of this file provided by LWsystems to you as
 * well as other copyrighted, protected or trademarked materials like
 * logos, graphics, fonts, specific documentations and configurations,
 * cryptographic keys etc. are subject to a license agreement between
 * you and LWsystems.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You can find a copy of the GNU Affero General Public License at
 * this URI:
 * http://www.gnu.org/licenses/agpl-3.0.html
 * If not, write to the Free Software Foundation, Inc., 59 Temple Place,
 * Suite 330, Boston, MA  02111-1307  USA
 */

/**
 * Benno MailArchiv License
 *
 */

class License
{

    /**
     * License File Content
     */
    var $_licenseFile;


    /**
     * License Status
     */
    var $status;


    /**
     * License Type
     */
    var $type;


    /**
     * License expires at
     */
    var $expires;


    /**
     * License Key
     */
    var $key;


    /**
     * License validity
     */
    var $valid;


    /**
     * Hostname 
     */
    var $hostname;


    /**
     * Host address
     */
    var $address;


    /**
     * REST build
     */
    var $restbuild;


    /**
     * CORE version
     */
    var $coreVersion;


    /**
     * REST version
     */
    var $restVersion;




    /**
     * Constructor
     *
     * @access public
     */
    function License ($licenseStatus,$licenseExpires,$licenseType,$licenseFile,$address,$hostname,$restbuild,$coreVersion,$restVersion)
    {

        if (preg_match('/^LICENSE_VALID/',$licenseStatus)) {
            $this->valid = true;
        }
        else {
            $this->valid = false;
        }

        $this->status = $licenseStatus;
        $this->expires = $licenseExpires;
        $this->type = $licenseType;

        
        $this->hostname = $this->formatMessage($hostname);
        $this->address =  $this->formatMessage($address);
        $this->restbuild = $restbuild;
        $this->_licenseFile = $licenseFile;

        $this->coreVersion = $coreVersion;
        $this->restVersion = $restVersion;

        $lines = preg_split('/\n/',$licenseFile);
        foreach ($lines as $line) {

            $param = ''; $value = '';
            @list($param,$value) = explode(':',$line);

            if ($param == 'LicenseKey') {
                $this->key = trim($value);
                continue;
            }
        }
    }


    function formatMessage($msgstring)
    {
        global $App;
        preg_match('/^(ERR_\S+):(.+)$/',$msgstring,$matches);
        if ($matches[1]) {
            $errmsg  = $App->getMsg($matches[1]);
            $ret = $errmsg.': '.$matches[2];
        }
        else {
            $ret = $msgstring;
        }
        
        return $ret;
    }
}
?>
