#!/usr/bin/perl
#
#
use strict;
use IPC::Open3;

my $DEBUG = $ENV{DEBUG};
my $auth_success = 0;

my $module_dir = '/etc/benno-web/auth.d';

my $firstline  = <STDIN>;
my $secondline = <STDIN>;
chomp $firstline;
chomp $secondline;

my $authproto;
my ($username,$password);
if (!$secondline) {
    # AUTHPROTO: STDIN
    ($username,$password) = split /\s+/,$firstline,2;
    $authproto = 1;
}
else {
    # AUTHPROTO: STDIN2
    $username = $firstline;
    $password = $secondline;
    $authproto = 2;
}
if (!$password) {
    print "ERROR ERR_NOPASS\n";
    print STDERR "Aufruf: echo -e \"<username>\n<passwort>\" | $0\n";
    exit 1;
}

opendir my $dh, $module_dir;
while (my $file = readdir $dh) {
    next if $file =~ /^\./;
    next if $file =~ /\.dpkg/;

    my $module = $module_dir.'/'.$file;
    next unless -x $module;
    print STDERR "Call $module\n" if $DEBUG;
    my $authstring;
    if ($authproto == 2) {
        $authstring = "$username\n$password";
    }
    else {
        $authstring = "$username $password";
    }

    my($wtr, $rdr, $err);
    use Symbol 'gensym'; $err = gensym;
    my $pid = open3($wtr, $rdr, $err, $module);
    print $wtr $authstring;
    close $wtr;
    waitpid( $pid, 0 );
    my $child_exit_status = $? >> 8;
    my @ret = <$rdr>;
    my $retcount = 0;
    foreach my $line (@ret) {
        if ($line =~ /^ERR/) {
            next;
        }
        $retcount++ if $line =~ /^MAIL/;
        $retcount++ if $line =~ /^ARCHIVE/;
        print $line;
    }
    if ($retcount >= 2) {
        $auth_success = 1;
        next;
    }
}
if (!$auth_success) {
    print "ERR AUTH\n";
}

