#!/bin/sh
# postinst script for benno-web
#
# see: dh_installdeb(1)

set -e

# summary of how this script can be called:
#        * <postinst> `configure' <most-recently-configured-version>
#        * <old-postinst> `abort-upgrade' <new version>
#        * <conflictor's-postinst> `abort-remove' `in-favour' <package>
#          <new-version>
#        * <postinst> `abort-remove'
#        * <deconfigured's-postinst> `abort-deconfigure' `in-favour'
#          <failed-install-package> <version> `removing'
#          <conflicting-package> <version>
# for details, see http://www.debian.org/doc/debian-policy/ or
# the debian-policy package

USER_DB=bennoweb.sqlite
ETC_DIR=/etc/benno-web
VAR_DIR=/var/lib/benno-web
SERVER_CONFIG=/etc/benno-web/benno.conf
SERVER_USER=benno
SERVER_GROUP=benno
WWW_USER=www-data
WWW_GROUP=www-data


case "$1" in
    configure)
        chgrp $WWW_GROUP $SERVER_CONFIG
        chmod u=rw,g=r,o= $SERVER_CONFIG

        set +e
        echo ""|sqlite /var/lib/benno-web/bennoweb.sqlite 2>/dev/null
        dbretval=$?
        if [ -f "$VAR_DIR/$USER_DB" ] && [ $dbretval = 0 ];then
            # convert database from slite2 to sqlite3
            mv "$VAR_DIR/$USER_DB" "$VAR_DIR/${USER_DB}2"
            echo .dump| sqlite "$VAR_DIR/${USER_DB}2" | sqlite3 "$VAR_DIR/$USER_DB"
        fi
        sqlite3 "$VAR_DIR/$USER_DB" < /usr/share/doc/benno-web/contrib/db-create.sql 2>/dev/null
        #
        sqlite3 "$VAR_DIR/$USER_DB" < /usr/share/doc/benno-web/contrib/db-update_2.0.1.sql 2>/dev/null
        #
        set -e

        chown $WWW_USER "$VAR_DIR/$USER_DB"
        chmod u=rw,g=r,o= "$VAR_DIR/$USER_DB"

        if [ -e /usr/share/apache2/apache2-maintscript-helper ];then
            # Debian Jessie / Apache2.4
            [ -d /etc/apache2/conf-available ] || mkdir -p /etc/apache2/conf-available
            ln -sf /etc/benno-web/apache-2.4.conf /etc/apache2/conf-available/benno.conf
            . /usr/share/apache2/apache2-maintscript-helper
            apache2_invoke enconf benno
        elif [ ! -f /etc/apache2/conf.d/benno ];then
            mkdir -p /etc/apache2/conf.d
            ln -sf /etc/benno-web/apache-2.2.conf /etc/apache2/conf.d/benno
        fi

        ## upgrade port settings
        #set +e
        #grep -q localhost:8080 /etc/benno-web/benno.conf 2>/dev/null
        #if [ $? -eq 0 ];then
        #    perl -p -i -e 's/localhost:8080$/localhost:21080/' /etc/benno-web/benno.conf
        #else
        #    BASEURL=`grep BASE_URL /etc/benno-web/benno.conf 2>/dev/null`
        #    echo ""
        #    echo ""
        #    echo "################################################################"
        #    echo "#  ACHTUNG! Bitte die Host- und Portkonfigurationen von"
        #    echo "#    /etc/benno-web/benno.conf: ${BASEURL}"
        #    echo "#  und"
        #    echo "#    /etc/benno/jetty.xml: \"host\" und \"port\""
        #    echo "#  vergleichen und gegebenenfalls anpassen."
        #    echo "################################################################"
        #fi
        #set -e

        # Auto-Create password
        if [ ! -f /etc/benno/rest.secret ];then
            openssl rand -hex 20 > /etc/benno/rest.secret
            echo -n 'SHARED_SECRET = '  > /etc/benno-web/rest.conf
            cat /etc/benno/rest.secret >> /etc/benno-web/rest.conf
        fi

        # Auth.d
        if [ ! -d /etc/benno-web/auth.d ];then
            mkdir /etc/benno-web/auth.d
        fi
        if [ ! -f /etc/benno-web/auth.conf ];then
            echo "# benno_auth.d configuration file" >> /etc/benno-web/auth.conf
            echo "#"                                 >> /etc/benno-web/auth.conf
            echo "module_dir=/etc/benno-web/auth.d"  >> /etc/benno-web/auth.conf
            echo ""                                  >> /etc/benno-web/auth.conf
        fi

    ;;

    abort-upgrade|abort-remove|abort-deconfigure)
    ;;

    *)
        echo "postinst called with unknown argument \`$1'" >&2
        exit 1
    ;;
esac

invoke-rc.d apache2 force-reload


exit 0
