#!/usr/bin/perl
#
#
use strict;
use IPC::Open3;

my $DEBUG = $ENV{DEBUG};
my $auth_success = 0;

my $config     = read_config('/etc/benno-web/auth.conf');
my $module_dir = $config->{module_dir} || '/etc/benno-web/auth.d';

$ENV{module_dir} = $module_dir;
foreach my $configvar (keys %{$config}) {
    $ENV{$configvar} = $config->{$configvar};
}


my $firstline  = <STDIN>;
my $secondline = <STDIN>;
chomp $firstline;
chomp $secondline;

my $authproto;
my ($username,$password);
if (!$secondline) {
    # AUTHPROTO: STDIN
    ($username,$password) = split /\s+/,$firstline,2;
    $authproto = 1;
}
else {
    # AUTHPROTO: STDIN2
    $username = $firstline;
    $password = $secondline;
    $authproto = 2;
}
if (!$password) {
    print "ERROR ERR_NOPASS\n";
    print STDERR "Aufruf: echo -e \"<username>\n<passwort>\" | $0\n";
    exit 1;
}
my @retlines;
chdir $module_dir;
opendir my $dh, $module_dir or die "Cannot read $module_dir/: $!";
foreach my $file (sort readdir($dh)) {
    next if $file =~ /^\./;
    next if $file =~ /\.dpkg/;
    next if not -f $file;

    my $module = $module_dir.'/'.$file;
    next unless -x $module;
    print STDERR "Call $module\n" if $DEBUG;
    my $authstring;
    if ($authproto == 2) {
        $authstring = "$username\n$password";
    }
    else {
        $authstring = "$username $password";
    }

    my($wtr, $rdr, $err);
    use Symbol 'gensym'; $err = gensym;
    my $pid = open3($wtr, $rdr, $err, $module);
    print $wtr $authstring;
    close $wtr;
    waitpid( $pid, 0 );
    my $child_exit_status = $? >> 8;
    my @ret = <$rdr>;
    foreach my $line (@ret) {
        chomp $line;
        chomp $line;
        if ($line =~ /^ERR/) {
            next; # no error to caller
        }
        if ($line =~ /^AUTH\sBREAK/) {
            print "WARN AUTH BREAK from $module\n";
            error_exit();
            exit 1;
        }
        if ($line =~ /^AUTH\s+OK/) {
            $auth_success = 1;
            next;
        }
        push @retlines, $line;
    }
}

# return retlines
foreach my $retline (@retlines) {
    print "$retline\n";
}

if ($auth_success) {
    print "AUTH OK\n";
    exit 0;
}
else {
    error_exit();
}


### SUBS ###
# read_config
sub read_config
{
    my $configfile = shift;
    my $config = {};

    # Config format:   var = val
    open CONF, "$configfile" or die "Cannot open config file $configfile. $!\n";
    foreach my $line (<CONF>) {
        next if $line =~ /^$/;
        next if $line =~ /^#/;
        chomp $line;
        my ($var,$val) = split(/=/, $line,2);
        # strip ws
        $var =~ s/\s//g;
        $val =~ s/^\s+//g;
        $val =~ s/\s+$//g;
        $config->{$var} = $val;
    }
    close CONF;
    return $config;
}

sub exit_error
{
    print "ERROR ERR_AUTH\n";
    exit 1;
}

#
# vim: set filetype=perl:
#
