<?php
/*
 * Benno MailArchiv
 *
 * Copyright  2008-2012 LWsystems GmbH & Co. KG
 *
 * http://www.lw-systems.de/
 * http://www.benno-mailarchiv.de/
 *
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License version 3
 * as published by the Free Software Foundation.
 *
 * Binary versions of this file provided by LWsystems to you as
 * well as other copyrighted, protected or trademarked materials like
 * logos, graphics, fonts, specific documentations and configurations,
 * cryptographic keys etc. are subject to a license agreement between
 * you and LWsystems.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You can find a copy of the GNU Affero General Public License at
 * this URI:
 * http://www.gnu.org/licenses/agpl-3.0.html
 * If not, write to the Free Software Foundation, Inc., 59 Temple Place,
 * Suite 330, Boston, MA  02111-1307  USA
 */

require_once 'SPAF2/Persistence.php';

class Filter extends Persistence
{

    var $id;
    var $userid;
    var $name;
    var $filter;


    function Filter ($id,$userid='',$name='',$filter='')
    {
        $this->id     = $id;
        $this->userid = $userid;
        $this->name   = $name;
        $this->filter = $filter;
    }


    /**
     * get filterstring for name
     *
     * @param string $filtername
     */
    function getString()
    {
        return $this->filter.' ';
    }


    /**
     * FetchList
     *
     * Class method to Fetch a list of objects from database
     *
     * @access public
     * @param object $User
     * @return array entries
     */
    public static function FetchList ($User)
    {  
        global $App;

        $filterList = array();
        $DB = $App->DB;

        // filter email adresses for this user
        foreach($User->addresses as $emailaddress) {
            $emailFilter = Filter::EmailFilter($emailaddress);
            $id = md5($emailFilter);
            $filterName = "Email: $emailaddress";
            $Filter = new Filter($id,$User->id,$filterName,$emailFilter);
            array_push($filterList,$Filter);
        }

        // import filters from Benno1 configuration (will be removed)
        //Filter::ImportBenno1Filter();

        // global filters
        $sql = "SELECT * FROM filter WHERE userid = 'ALL' ORDER BY name";
        $res = $DB->query($sql);
        while ($row = $res->fetchRow()) {
            array_push($filterList,new Filter($row['id'],$row['userid'],$row['name'],$row['filter']));
        }

        // user specific filters
        $sql = "SELECT * FROM filter WHERE userid = '".$User->id."' ORDER BY name";
        $res = $DB->query($sql);
        while ($row = $res->fetchRow()) {
            array_push($filterList,new Filter($row['id'],$row['userid'],$row['name'],$row['filter']));
        }

        return $filterList;
    }


    /**
     * ImportBenno1Filter (deprecated)
     *
     * Import filters from Benno1 and store them at the DB backend.
     *
     * @access public
     */
    public static function ImportBenno1Filter ()
    {  
        global $App;
        $query_file = '/etc/benno/exclude-queries';

        $line = '';
        $handle = fopen($query_file, 'r');
        if ($handle) {
            while (($line = fgets($handle, 4096)) !== false) {
                if (preg_match('/^(#|$)/',$line)) continue;
                $line = preg_replace('/^header/','',$line);
                preg_match('/(\S+):(.+)$/',$line,$matches);

                $exclude_header = $matches[1];
                $exclude_string = '"'.trim($matches[2]).'"';
                $filter_string = $exclude_header.':'.$exclude_string;
                $id = md5($line);
                $Filter = new Filter($id,'ALL',$line,$filter_string);
                $Filter->save();
            }
            if (!feof($handle)) {
            }
            fclose($handle);
        }
    }


    /**
     * Class method returns the query filter for an email address
     *
     * @access public
     * @param string $emailaddress
     * @return string $filter
     */
    public static function EmailFilter($address)
    {
        $filter_attributes = array('From','To','Recipient','Sender');

        $address_lowered = strtolower($address);

        $filter = '';
        foreach($filter_attributes as $attribute) {
            $filter .=  $attribute.':'.$address.' ';
        }
        $filter = rtrim($filter); // remove trailing whitespace
        return '('.$filter.')';
    }

}
?>
