<?php
/*
 * Benno MailArchiv
 *
 * Copyright  2008-2012 LWsystems GmbH & Co. KG
 *
 * http://www.lw-systems.de/
 * http://www.benno-mailarchiv.de/
 *
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License version 3
 * as published by the Free Software Foundation.
 *
 * Binary versions of this file provided by LWsystems to you as
 * well as other copyrighted, protected or trademarked materials like
 * logos, graphics, fonts, specific documentations and configurations,
 * cryptographic keys etc. are subject to a license agreement between
 * you and LWsystems.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You can find a copy of the GNU Affero General Public License at
 * this URI:
 * http://www.gnu.org/licenses/agpl-3.0.html
 * If not, write to the Free Software Foundation, Inc., 59 Temple Place,
 * Suite 330, Boston, MA  02111-1307  USA
 */
include_once 'model/MailObject.php';

$QueryResult = $App->getSession('QueryResult');

$sessionMailId = $App->getParam('id');

try {
    $EMail = $Backend->fetch($archive,$sessionMailId);
    $App->setSession('sessionMailId',$sessionMailId);
    $App->setSession('EMail',$EMail);

}
catch (Exception $e) {
    $errorMsg = $e->getMessage();
    $App->log($errorMsg);
}

$permaId = base64_encode($EMail->bennoId.'@'.$EMail->archive);
$MailObject = new MailObject($EMail->id,$permaId);
$MailObject->from       = $EMail->getFrom();
$MailObject->to         = $EMail->getTo();
$MailObject->cc         = $EMail->getCc();
$MailObject->bcc        = $EMail->getBcc();
$MailObject->subject    = $EMail->getSubject();
$MailObject->verified   = $EMail->isVerified();

$atm_list = array();
foreach ($EMail->getAttachments() as $Attachment) {
    $atm['id']           = urlencode($Attachment->id);
    $atm['attachmentId'] = $Attachment->attachmentId;
    $atm['type']         = $Attachment->type;
    $atm['size']         = $Attachment->size;
    $atm['icon']         = $Attachment->getIcon();
    array_push($atm_list,$atm);
}
$MailObject->attachments= $atm_list;

$default_contenttype = $App->getConfig('DEFAULT_CONTENTYPE','text/html');
try {
    $body_content = $EMail->getBody($default_contenttype);
    $body_type = $default_contenttype;
}
catch (Exception $e) {
    if ($e->getMessage() == 'NO_CONTENT') {
        if ($default_contenttype == 'text/html') {
            $body_type = 'text/plain';
        }
        else {
            $body_type = 'text/html';
        }
    }
}
try {
    $body_content = $EMail->getBody($body_type);
}
catch (Exception $e) {
    $App->log('Cannot fetch email body: '.$e->getMessage(),1,'a_showEmail');
}

$mailDate = $EMail->getDate();
$MailObject->setDate(strftime($LOCALE['dateformat'],$mailDate));
$MailObject->setTime(strftime($LOCALE['timeformat'],$mailDate));
$MailObject->setBody($body_content,$body_type);

if ($errorMsg) {
    $MailObject->setError('ID_NOT_FOUND');
}
$App->response(json_encode($MailObject),'application/json');
?>
