<?php
/*
 * Benno MailArchiv
 *
 * Copyright  2008-2012 LWsystems GmbH & Co. KG
 *
 * http://www.lw-systems.de/
 * http://www.benno-mailarchiv.de/
 *
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License version 3
 * as published by the Free Software Foundation.
 *
 * Binary versions of this file provided by LWsystems to you as
 * well as other copyrighted, protected or trademarked materials like
 * logos, graphics, fonts, specific documentations and configurations,
 * cryptographic keys etc. are subject to a license agreement between
 * you and LWsystems.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You can find a copy of the GNU Affero General Public License at
 * this URI:
 * http://www.gnu.org/licenses/agpl-3.0.html
 * If not, write to the Free Software Foundation, Inc., 59 Temple Place,
 * Suite 330, Boston, MA  02111-1307  USA
 */


class Attachment
{
    /*
     * Name of the attachment
     */
    var $id;
    
    /*
     * attachmentId
     */
    var $attachmentId;

    
    /*
     * Content-Type
     */
    var $type;


    /*
     * Attachment size
     */
    var $size;


    /*
     * download
     */
    var $download;


    function Attachment ($id,$type='',$size='', $download=true, $attachmentId='')
    {
        $this->id   = $id;
        $this->type = $type;
        $this->size = $size;
        $this->download = $download;
        $this->attachmentId = $attachmentId;
    }


    function getIcon()
    {
        $prefix = 'icon_';
        $type   = 'attachment.gif';
        if (preg_match('/\.pdf$/',$this->id)) { $type = 'pdf.gif'; }
        if (preg_match('/\.doc$/',$this->id)) { $type = 'doc.gif'; }
        if (preg_match('/\.xls$/',$this->id)) { $type = 'xls.gif'; }
        if (preg_match('/\.zip$/',$this->id)) { $type = 'zip.gif'; }
        if (preg_match('/\.jpg$/i',$this->id)) { $type = 'jpeg.gif'; }

        // Todo: implementation of signature check
        if (preg_match('/\.asc$/',$this->id)) {
            $this->download = false;
            $type = 'signature.gif';
        }
        if (preg_match('/\.p7s$/',$this->id)) {     // S/MIME SIGNATURE
            $this->download = false;
            $type = 'signature.gif';
        }

        // multipart/text bodies (disclaimer)
        if (preg_match('/^content.disclaimer$/',$this->id)) {
            $this->download = false;
            $type = 'signature.gif';
        }

        return $prefix.$type;
    }

}
?>
