<?php
/*
 * Benno MailArchiv
 *
 * Copyright  2008-2016 LWsystems GmbH & Co. KG
 *
 * http://www.lw-systems.de/
 * http://www.benno-mailarchiv.de/
 *
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License version 3
 * as published by the Free Software Foundation.
 *
 * Binary versions of this file provided by LWsystems to you as
 * well as other copyrighted, protected or trademarked materials like
 * logos, graphics, fonts, specific documentations and configurations,
 * cryptographic keys etc. are subject to a license agreement between
 * you and LWsystems.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You can find a copy of the GNU Affero General Public License at
 * this URI:
 * http://www.gnu.org/licenses/agpl-3.0.html
 * If not, write to the Free Software Foundation, Inc., 59 Temple Place,
 * Suite 330, Boston, MA  02111-1307  USA
 */
$permalink = $App->getParam('id');

// decode permalink
try {
    $PermaId = new PermaId();
    list($bennoId,$permaArchive) = $PermaId->decrypt($permalink);
}
catch (Exception $e) {
        $msg = $e->getMessage();
        $App->log($msg);
        $App->setMsg($msg);
        $App->redirect('index.php?CA=default',array('MSG' => $msg));
}


$filterString = "(id:*)";

if ($App->getConfig('PERMALINK_UNAUTHENTICATED') != 'yes') {
    $App->redirect('index.php?CA=default',array('id' => $permalink));
}


$RESTconf = new ApplicationConfig($App->configdir);
$RESTconf->load($App->getConfig('REST_CONFIG','rest.conf'),false);

// defaults: compatibility to deprecated configuration
$base_url_mainconf = $App->getConfig('BASE_URL','http://localhost:21080');
$base_url  = $RESTconf->getConfig('BASE_URL',$base_url_mainconf);
$rest_user = $RESTconf->getConfig('REST_USER','benno2');
$rest_pass = $RESTconf->getConfig('SHARED_SECRET',$App->getConfig('SHARED_SECRET'));
$Backend = new Backend($base_url,$rest_user,$rest_pass,$filterString);

$PermaQuery = new Query($permalink,$permaArchive,$bennoId);
$PermaQuery->type = 'RepoPath';
try {
    // fresh search, thus we start with position 1
    $QueryResult = $Backend->query($permaArchive,$PermaQuery,0,1);
    if ($QueryResult->found == 0) {
        $App->setMsg('MSG_NOTFOUND');
        $sessionMailId = '';
    }
}
catch (Exception $e) {
    if ($e->getMessage() == 'ID_NOT_FOUND') {
        $App->view = 'permalink_body';
    }
    else {
        $App->log($e->getMessage());
        $App->setMsg($e->getMessage());
    }
}

// Redirect from Login
if (!$permalink) {
    $permalink = $App->getSession('permalink');
    $App->unsetSession('LOGIN_REDIRECT');
}

$sessionMailId = $QueryResult->getSessionMailId(0);
$App->view = 'permalink_body';

?>
