<?php
/*
 * Benno MailArchiv
 *
 * Copyright  2008-2012 LWsystems GmbH & Co. KG
 *
 * http://www.lw-systems.de/
 * http://www.benno-mailarchiv.de/
 *
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License version 3
 * as published by the Free Software Foundation.
 *
 * Binary versions of this file provided by LWsystems to you as
 * well as other copyrighted, protected or trademarked materials like
 * logos, graphics, fonts, specific documentations and configurations,
 * cryptographic keys etc. are subject to a license agreement between
 * you and LWsystems.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You can find a copy of the GNU Affero General Public License at
 * this URI:
 * http://www.gnu.org/licenses/agpl-3.0.html
 * If not, write to the Free Software Foundation, Inc., 59 Temple Place,
 * Suite 330, Boston, MA  02111-1307  USA
 */

/**
 * Benno MailArchiv
 *
 */

class PermaId
{
    var $pass;


    /**
     * Constructor
     *
     * @access public
     * @return string $info
     */
    function PermaId()
    {
        global $App;
        $passfile = $App->getConfig('PERMALINK_PASSFILE ','/etc/benno-web/permalink.pass');
        
        $pass = @file_get_contents($passfile);
        $this->pass = $pass;
    }


    /**
     * encrypt
     *
     * @access public
     * @param string $bennoId
     * @param string $container
     * @return string $permaId
     */
    public function encrypt($bennoId,$container)
    {
        // compress data for future options of perma id
        $idString = gzcompress($bennoId.'@'.$container);

        $ivlen = openssl_cipher_iv_length($cipher="AES-256-CBC");
        $iv = openssl_random_pseudo_bytes($ivlen);
        $cipherId = openssl_encrypt($idString,$cipher,$this->pass,0,$iv);
        $permaId = base64_encode($iv.$cipherId);

        // URL safe encoding
        $bchars = array('+','/','=');
        $uchars = array('-','_','');
        $permaId = str_replace($bchars,$uchars,$permaId);
        return $permaId;
    }


    /**
     * decrypt
     *
     * @access public
     * @param string $permaId
     * @return array ($permaId,$container)
     */
    public function decrypt($permaId)
    {
        // URL safe decoding
        $bchars = array('+','/','=');
        $uchars = array('-','_','');
        $permaId = str_replace($uchars,$bchars,$permaId);
        $mod4 = strlen($permaId) % 4;
        if ($mod4) {
            $permaId .= substr('====',$mod4);
        }
        $cipherTxt = base64_decode($permaId);

        $ivlen = openssl_cipher_iv_length($cipher="AES-256-CBC");
        $iv = substr($cipherTxt,0,$ivlen);      // fetch iv
        $cipherId = substr($cipherTxt,$ivlen);  // fetch cypherId
        $idStringzip = openssl_decrypt($cipherId,$cipher,$this->pass,0,$iv);

        $idString = '';
        if ($idStringzip == '') {   // unencrypted permaId, try to decode
            $idString = $cipherTxt;
        }
        else {
            $idString = gzuncompress($idStringzip);
        }

        list($bennoId,$container) = explode('@',$idString,2);
        if ($container == '') {
            throw new Exception('ERR_PERMAID');
        }

        return array($bennoId,$container);
    }
    




}
?>
