<?php
/*
 * Benno MailArchiv
 *
 * Copyright  2008-2012 LWsystems GmbH & Co. KG
 *
 * http://www.lw-systems.de/
 * http://www.benno-mailarchiv.de/
 *
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License version 3
 * as published by the Free Software Foundation.
 *
 * Binary versions of this file provided by LWsystems to you as
 * well as other copyrighted, protected or trademarked materials like
 * logos, graphics, fonts, specific documentations and configurations,
 * cryptographic keys etc. are subject to a license agreement between
 * you and LWsystems.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You can find a copy of the GNU Affero General Public License at
 * this URI:
 * http://www.gnu.org/licenses/agpl-3.0.html
 * If not, write to the Free Software Foundation, Inc., 59 Temple Place,
 * Suite 330, Boston, MA  02111-1307  USA
 */

/** $Id: $
 *
 */
/**
 * @package User
 */
/**
 *
 * User
 *
 */
require_once 'model/UserDA.php';

class User extends UserDA
{
    /** id
     *
     * @access private
     * @var string
     */
    var $id;


    /** password
     *
     * @access private
     * @var string
     */
    var $password;


    /** display name of user
     *
     * @access private
     * @var string
     */
    var $name;


    /** archive to access
     *
     * @access private
     * @var string
     */
    var $archive;


    /** addresses
     *
     * @access private
     * @var array
     */
    var $addresses;


    /** role
     *
     * Authorization level:
     *     ADMIN    16
     *     REVISOR   4
     *     USER      2
     *
     * @access public
     * @var string
     */
    var $role;


   /**
     * restdata
     *
     * Information about REST backend
     *  rest['URL']
     *  rest['USER']
     *  rest['PASS']
     *
     * @access public
     * @var array
     */
    var $restdata;


    /**
     * constructor
     *
     *
     * @access public
     * @param string $userid
     * @param string $password optional
     * @param string $archive optional
     * @param string $role optional
     * @param array $addresses optional
     * @param array $restdata optional
     * @return object
     */
    function User ($id,$password='',$name='',$archive=array(),$role='',$adresses=array(),$restdata=array())
    {
        $this->id = $id;
        $this->password = $password;
        $this->name = $name;
        $this->archive = $archive;
        $this->role = $role;
        $this->addresses = $adresses;
        $this->restdata= $restdata;
    }

    function getAuthzLevel () {
        if ($this->role == 'ADMIN')   { return 16; }
        if ($this->role == 'REVISOR') { return 4; }
        if ($this->role == 'USER')    { return 2; }
    }

    function setPassword ($pass) { $this->password = $password; }

    function getName () { return $this->name; }
    function setName ($name) { $this->name = $name; }

    function getArchives () { return $this->archive; }
    function addArchive ($archive) { array_push($this->archive,$archive); }

    function getAdresses () { return $this->adresses; }
    function setAdresses ($adresses) { $this->adresses = $adresses; }

    function setRestData ($restdata) { $this->restdata = $restdata; }
    function getRestData () { return $this->restdata; }
}
?>
