<?php
/*
 * Benno MailArchiv
 *
 * Copyright  2008-2012 LWsystems GmbH & Co. KG
 *
 * http://www.lw-systems.de/
 * http://www.benno-mailarchiv.de/
 *
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License version 3
 * as published by the Free Software Foundation.
 *
 * Binary versions of this file provided by LWsystems to you as
 * well as other copyrighted, protected or trademarked materials like
 * logos, graphics, fonts, specific documentations and configurations,
 * cryptographic keys etc. are subject to a license agreement between
 * you and LWsystems.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You can find a copy of the GNU Affero General Public License at
 * this URI:
 * http://www.gnu.org/licenses/agpl-3.0.html
 * If not, write to the Free Software Foundation, Inc., 59 Temple Place,
 * Suite 330, Boston, MA  02111-1307  USA
 */

require_once 'model/User.php';
require_once 'model/DateConvert.php';
require_once 'model/Filter.php';
require_once 'model/AppState.php';

$authscript  = $App->getConfig('EXTERNAL_AUTH','/usr/sbin/benno_auth.d');

$login = $App->getParam('login');

$userid = $login['username'];
$passwd = $login['password'];

if (! $passwd) {
    $App->redirect('default',array('MSG'=>'ERR_NOPASS'));
}

$RESTconf = new ApplicationConfig($App->configdir);
$RESTconf->load($App->getConfig('REST_CONFIG','rest.conf'),false);

// defaults: compatibility to deprecated configuration
$base_url_mainconf = $App->getConfig('BASE_URL','http://localhost:21080');
$rest_data['URL']  = $RESTconf->getConfig('BASE_URL',$base_url_mainconf);
$rest_data['USER'] = $RESTconf->getConfig('REST_USER','benno2');
$rest_data['PASS'] = $RESTconf->getConfig('SHARED_SECRET',$App->getConfig('SHARED_SECRET'));

$USER = new User($userid);
$USER->setRestData($rest_data);  // set defaults from config
try {
    if ($authscript && is_readable($authscript)) {
        $USER->loadExternal($authscript,$passwd);
    }
    else {
        $App->log("Cannot read \"$authscript\". Fallback authentication.");
        $USER->load();
        // check authentication
        if ($USER->password != md5($passwd)) {
            // Authentication error -> redirect to login
            $App->log('Authentication of '.$USER->id.' failed');
            $App->redirect('default',array('MSG'=>'ERR_AUTH'));
        }
    }
}
catch (Exception $e) {
    $exc = $e->getMessage();
    $App->log('Authentication error: '.$exc);
    $App->redirect('default',array('MSG'=>$exc));
}

// LOGIN SUCCESSFUL
$App->log('Authentication of '.$USER->id. ' successful',1);
$App->setSession('DISABLED',$App->getConfigList('INFO_DISABLED',array()));

// initialize backend
$FilterList = Filter::FetchList($USER);
$filterString = '';
foreach ($FilterList as $Filter) {
    $filterString .= $Filter->getString();
}

$rest_data = $USER->getRestData();
$Backend = new Backend($rest_data['URL'],$rest_data['USER'],$rest_data['PASS'],
                       $filterString);

// defaults for extended search form
$timerange = $App->getConfig('DEFAULT_TIMERANGE','30');
$ExtQuery = new Query('empty');
$App->setSession('ExtQuery',$ExtQuery);

$App->setSession('QueryList',StoredQuery::FetchList($USER->id));

// list of assigned archives
$archive_list = $USER->getArchives();
foreach ($archive_list as $archive) { // disable index counter if subarchives available
    list($cidstring,$scid) = preg_split('/\/+(?=[^\/]+$)/',$archive);
    if ($scid) {
        // disable indexed mails counter always
        $DISABLED = $App->getSession('DISABLED');
        array_push($DISABLED,'INDEXCOUNT');
        $App->setSession('DISABLED',$DISABLED);
    }
}


// restore state of last session
try {
    // searchMask
    $AppState = new AppState($USER->id);
    $searchMaskState = $AppState->getValue('searchMaskState','Simple');
    $App->setSession('searchMaskState',$searchMaskState);

    // set current archive
    if (!in_array($AppState->getValue('archive'),$archive_list)) {
        $AppState->saveValue('archive','');
    }
    if (!$archive = $AppState->getValue('archive')) {
        $archive = end($archive_list);
    }

    // search SPAM
    $App->setSession('isSpam',$AppState->getValue('isSpam'));

    // Language
    if ($App->getParam('interfaceLanguage')) {
        $AppState->saveValue('userLanguage',$App->getParam('interfaceLanguage'));
        $App->setLang($App->getParam('interfaceLanguage'));
    }
    else {
        $userLanguage = $AppState->getValue('userLanguage');
        if ($userLanguage) {
            $App->setLang($userLanguage);
        }
    }
}
catch (Exception $e) {
    $App->log('Error loading application state: '.$e->getMessage());
}

// initialize session
$App->setSession('ACCESS_LEVEL',$USER->getAuthzLevel());
$App->setSession('USER',$USER);
$App->setSession('Backend',$Backend);   // store backend for this session
$App->setSession('archive',$archive);   // store current archive
$App->setSession('FilterList',$FilterList);

if ($USER->getAuthParam('AUTHBY') == 'db') { // show admin ui
    $App->setSession('USERPANEL',true);
}

// set language on change and after login for 32 days
setcookie("BENNO_LANGUAGE", $LANG, time()+2764800, dirname($_SERVER['REQUEST_URI']));


if ($redirect = $App->getSession('LOGIN_REDIRECT')) {
    // redirect to permalink
    $App->redirect($redirect);
}
else {
    $login_showlast = $App->getConfig('LOGIN_SHOWLAST',-1);
    if ($login_showlast > -1) {
        $App->redirect('showCurrent');
    }
    else {
        $App->redirect('greeting');
    }
}

?>
