<?php
/*
 * Benno MailArchiv
 *
 * Copyright  2008-2012 LWsystems GmbH & Co. KG
 *
 * http://www.lw-systems.de/
 * http://www.benno-mailarchiv.de/
 *
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License version 3
 * as published by the Free Software Foundation.
 *
 * Binary versions of this file provided by LWsystems to you as
 * well as other copyrighted, protected or trademarked materials like
 * logos, graphics, fonts, specific documentations and configurations,
 * cryptographic keys etc. are subject to a license agreement between
 * you and LWsystems.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You can find a copy of the GNU Affero General Public License at
 * this URI:
 * http://www.gnu.org/licenses/agpl-3.0.html
 * If not, write to the Free Software Foundation, Inc., 59 Temple Place,
 * Suite 330, Boston, MA  02111-1307  USA
 */

/** $Id: $
 *
 */
/**
 * @package User
 */
/**
 *
 * Abstract class to access User object data from storage
 *
 */
require_once 'SPAF2/Persistence.php';


class UserDA extends Persistence
{

    /**
     * FetchList
     *
     * Fetch a list of User objects from database
     *
     * @access public
     * @return array entries
     */
    public static function FetchList ($archive)
    {
        global $App;
        $entries = array();

        $DB = $App->DB;
        $sql = "SELECT * FROM user WHERE archive = '".$archive."' ORDER BY name";
        $res = $DB->query($sql);
        while ($row = $res->fetchRow()) {
            $obj = new User($row['id']);
            $obj->load();
            if (!$obj->name) $obj->name = $obj->id;
            array_push($entries,$obj);
        }

        return $entries;
    }

    // Overwrites Persistence::load()
    function load ()
    {
        global $App;
        $DB = $App->DB;
        $sql = "SELECT * FROM user WHERE id = '$this->id'";
        $res = $DB->query($sql);
        // read data from query
        $row = $res->fetchRow();
        $this->password = $row['password'];
        $this->name = $row['name'];
        array_push($this->archive,$row['archive']);
        $this->role = $row['role'];

        // read address data
        $sql = "SELECT address FROM address WHERE id = '$this->id'";
        $res = $DB->query($sql);
        while($row = $res->fetchRow()) {
            array_push($this->addresses,$row['address']);
        }

        if ($this->role == 'ADMIN' || $this->role == 'REVISOR') {
            array_unshift($this->archive,'SYSDATA');
        }

        return FALSE;
    }


    // load userdata from external userdb via script parameters
    function loadExternal ($script,$loadpass=false)
    {
        global $App;

        if (!is_executable($script)) {
            $App->log('Authentication script "'.$script.'" is not executable.',2);
            throw new Exception('ERR_EXECUTE');
        }

        try {
            return $this->loadSExternal($script,$loadpass);
        }
        catch (Exception $e) {
            $esc = $e->getMessage();
            if ($esc == 'ERR_AUTH') {
                throw new Exception('ERR_AUTH');
            }
            if ($esc != 'ERR_EXECUTE') {
                // external auth via STDIN failed
                $App->log('External auth with STDIN protocol failed.');
            }
            else { 
                throw new Exception('ERR_EXECUTE');
            }
        }

        if ($loadpass === false) {
            $password = escapeshellcmd($this->password);
        }
        else {
            $password = escapeshellcmd($loadpass);
            $this->password = $loadpass;
        }

        // call script an read userdata from stdout
        //
        // Returnvalues:
        //  ERROR ERR_AUTH | ERR_INTERN | (symbol in benno-errors.txt)
        //  ROLE USER | REVISOR | ADMIN
        //  DISPLAYNAME Martin Werthmöller
        //  ARCHIVE LWsystems
        //  MAIL mw@lw-systems.de
        //  MAIL m.werthmoeller@lw-systems.de
        //  MAIL info@lw-systems.de
        $cmd = escapeshellcmd($script);
        $username = escapeshellcmd($this->id);
        $App->log('(DEPRECATED) Call "'.$script.'" to authenticate.',0);
        $retvalue = shell_exec("$cmd \"$username\" \"$password\"");
        return $this->_check_external_return($retvalue);
    }


    // load userdata from external userdb via script stdin/out
    function loadSExternal ($script,$loadpass=false)
    {
        global $App;

        if ($loadpass === false) {
            $password = $this->password;
        }
        else {
            $password = ($loadpass);
        }
        $username = $this->id;

        $fd = array(
            0 => array('pipe', 'r'),
            1 => array('pipe', 'w'),
            2 => array('pipe', 'w')
        );

        $cmd = escapeshellcmd($script);
        $process = proc_open($cmd, $fd, $pipes);
        $App->log('Call "'.$script.'" to authenticate.',2);

        $auth_sep = ' ';
        // check for whitespace (FS#140)
        if (strpos($username,' ') !== false) {
            $auth_sep = "\n"; 
            $App->log('WARN: Username contains whitespace: Use \n as separator');
        }
        if (strpos($password,' ') !== false) {
            $auth_sep = "\n"; 
            $App->log('WARN: Password contains whitespace: Use \n as separator');
        }

        if (is_resource($process)) {
            // write "<username>$auth_sep<password>"
            fwrite($pipes[0], $username.$auth_sep.$password);
            fclose($pipes[0]);

            // read stdout from script
            $retvalue = stream_get_contents($pipes[1]);
            fclose($pipes[1]);

            $errvalue = stream_get_contents($pipes[2]);
            fclose($pipes[2]);
            if ($errvalue) {
                error_log('Authentication script error: '.$errvalue);
            }

            $return_value = proc_close($process);
        }
        // Returnvalues:
        //  ERROR ERR_AUTH | ERR_INTERN | (symbol in benno-errors.txt)
        //  ROLE USER | REVISOR | ADMIN
        //  DISPLAYNAME Martin Werthmöller
        //  ARCHIVE LWsystems
        //  MAIL mw@lw-systems.de
        //  MAIL m.werthmoeller@lw-systems.de
        //  MAIL info@lw-systems.de
        //  USERID <internal_userid>
        return $this->_check_external_return($retvalue);
    }


    // Overwrites Persistence::save()
    function save ()
    {
        global $App;

        $DB = $App->DB;
        $DB->startTransaction();
        $sql = "DELETE FROM address WHERE id = '$this->id'";
        $res = $DB->query($sql);

        $sql = "INSERT INTO address (id,address) VALUES (?,?)";
        $sth = $DB->db->prepare($sql);
        try {
            foreach ($this->addresses as $address) {
                $sth->bindValue(1,$this->id);
                $sth->bindValue(2,$address);
                $res = $sth->execute();
            }
        }
        catch(PDOException $e){ 
            $App->log('WARN '.$e->getMessage(),0);
        }

        // remove SYSDATA
        $containers = '';
        foreach ($this->archive as $container) {
            if ($container == 'SYSDATA') continue;
            $containers .= $container.',';
        }
        $containers = rtrim($containers,',');
        
        $sql = "DELETE FROM user WHERE id = '$this->id'";
        $res = $DB->query($sql);
        $sql = "INSERT INTO user (id,name,password,archive,role) VALUES (?,?,?,?,?)";
        $sth = $DB->db->prepare($sql);
        try {
            $sth->bindValue(1,$this->id);
            $sth->bindValue(2,$this->name);
            $sth->bindValue(3,$this->password);
            $sth->bindValue(4,$containers);
            $sth->bindValue(5,$this->role);
            $res = $sth->execute();
        }
        catch(PDOException $e){ 
            $App->log('WARN '.$e->getMessage(),0);
        }
        $DB->endTransaction();
    }


    // private
    function _check_external_return($retvalue) {
        global $App;
        $retlines = preg_split('/\n/',$retvalue);
        foreach ($retlines as $line) {
            $line = trim($line);
            if (!$line) continue;
            list($mark,$data) = preg_split('/\s/',$line,2);
            switch ($mark) {
                case 'ERROR':
                    throw new Exception($data);
                    break;
                case 'WARN':
                    $App->log('WARN '.$data,0);
                    break;
                case 'ROLE':
                    $this->role = $data;
                    break;
                case 'DISPLAYNAME':
                    $this->name = $data;
                    break;
                case 'ARCHIVE':
                    array_push($this->archive,$data);
                    break;
                case 'MAIL':
                    array_push($this->addresses,$data);
                    break;
                case 'AUTHPARAM':
                    $this->authparam = array_merge(
                            $this->authparam,$this->_parse_param($data));
                    break;
                case 'USERID':
                    $this->id = $data;
                    break;
                case 'RESTURL':
                    $this->restdata['URL'] = $data;
                    break;
                case 'RESTUSER':
                    $this->restdata['USER'] = $data;
                    break;
                case 'RESTPASS':
                    $this->restdata['PASS'] = $data;
                    break;
            }
        }

        if (!$this->role)    {
            error_log("[User::external] ROLE not set by external auth");
            throw new Exception('ERR_AUTH');
        }
        if (!$this->archive) {
            error_log("[User::external] ARCHIVE not set by external auth");
            throw new Exception('ERR_ARCHIVE');
        }
        $this->archive = array_unique($this->archive);

        if ($this->role == 'ADMIN' || $this->role == 'REVISOR') {
            array_unshift($this->archive,'SYSDATA');
        }
        return FALSE;
    }


    // split ':' into array
    function _parse_param($authparam)
    {
        list($param,$value) = explode(':',$authparam,2);
        $p[$param] = $value;

        return $p;
    }
}
?>
